/*
 * Decompiled with CFR 0.152.
 */
package unirest.shaded.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import unirest.shaded.org.apache.http.Header;
import unirest.shaded.org.apache.http.HttpException;
import unirest.shaded.org.apache.http.HttpRequest;
import unirest.shaded.org.apache.http.HttpRequestInterceptor;
import unirest.shaded.org.apache.http.annotation.Contract;
import unirest.shaded.org.apache.http.annotation.ThreadingBehavior;
import unirest.shaded.org.apache.http.protocol.HttpContext;
import unirest.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

