/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.nlp.tokenizers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.tokenizers.Tokenizer;

class LanguageToolTokenizer
implements Tokenizer {
    private final Language language;

    public LanguageToolTokenizer(Language language) {
        this.language = language;
    }

    public List<String> tokenize(String sentence) {
        Tokenizer tokenizer = this.language.getWordTokenizer();
        List rawTokens = tokenizer.tokenize(sentence);
        ArrayList<String> tokens = new ArrayList<String>();
        for (String rawToken : rawTokens) {
            String token = LanguageToolTokenizer.parseToken(rawToken);
            if (StringUtils.isBlank((String)token)) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private static String parseToken(String rawToken) {
        if (rawToken.contains("/")) {
            return StringUtils.trimToEmpty((String)rawToken.substring(0, rawToken.indexOf(47)));
        }
        return StringUtils.trimToEmpty((String)rawToken);
    }
}

