/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.ssl;

import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.ssl.SslConfig;
import io.undertow.Undertow;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.xnio.Options;
import org.xnio.Sequence;

public class SslBuilder {
    protected Undertow.Builder builder;
    protected UndertowConfig undertowConfig;
    protected SslConfig sslConfig;

    public SslBuilder(Undertow.Builder builder, UndertowConfig undertowConfig) {
        this.builder = builder;
        this.undertowConfig = undertowConfig;
        this.sslConfig = undertowConfig.getSslConfig();
    }

    public void build() {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.sslConfig.getProtocol());
            sslContext.init(this.getKeyManagers(this.sslConfig), null, null);
            this.builder.addHttpsListener(this.sslConfig.port, this.undertowConfig.getHost(), sslContext);
            if (this.sslConfig.getCiphers() != null) {
                this.builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Object[])this.sslConfig.getCiphers()));
            }
            if (this.sslConfig.getEnabledProtocols() != null) {
                this.builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Object[])this.sslConfig.getEnabledProtocols()));
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected KeyManager[] getKeyManagers(SslConfig sslConfig) {
        try {
            char[] keyPassword;
            KeyStore keyStore = this.loadKeyStore(sslConfig);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray = keyPassword = sslConfig.getKeyPassword() != null ? sslConfig.getKeyPassword().toCharArray() : null;
            if (keyPassword == null && sslConfig.getKeyStorePassword() != null) {
                keyPassword = sslConfig.getKeyStorePassword().toCharArray();
            }
            keyManagerFactory.init(keyStore, keyPassword);
            if (sslConfig.getKeyAlias() != null) {
                return this.getConfigurableAliasKeyManagers(sslConfig, keyManagerFactory.getKeyManagers());
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected KeyStore loadKeyStore(SslConfig sslConfig) throws Exception {
        String keyStoreType = sslConfig.getKeyStoreType();
        String keyStore = sslConfig.getKeyStore();
        String keyStorePassword = sslConfig.getKeyStorePassword();
        InputStream stream = this.undertowConfig.getClassLoader().getResourceAsStream(keyStore);
        if (stream == null) {
            stream = Files.newInputStream(Paths.get(keyStore, new String[0]), new OpenOption[0]);
        }
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore ret = keyStoreType != null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(KeyStore.getDefaultType());
            ret.load(is, keyStorePassword != null ? keyStorePassword.trim().toCharArray() : null);
            KeyStore keyStore2 = ret;
            return keyStore2;
        }
    }

    protected KeyManager[] getConfigurableAliasKeyManagers(SslConfig sslConfig, KeyManager[] keyManagers) {
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509ExtendedKeyManager)) continue;
            keyManagers[i] = new ConfigurableAliasKeyManager((X509ExtendedKeyManager)keyManagers[i], sslConfig.getKeyAlias());
        }
        return keyManagers;
    }

    protected static class ConfigurableAliasKeyManager
    extends X509ExtendedKeyManager {
        protected X509ExtendedKeyManager keyManager;
        protected String alias;

        protected ConfigurableAliasKeyManager(X509ExtendedKeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
            return this.keyManager.chooseEngineClientAlias(strings, principals, sslEngine);
        }

        @Override
        public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
            if (this.alias == null) {
                return this.keyManager.chooseEngineServerAlias(s, principals, sslEngine);
            }
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
    }
}

