/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.apt;

import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.jcabi.aspects.Async"})
public final class AsyncReturnTypeProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        for (TypeElement typeElement : annotations) {
            this.checkMethods(env, typeElement);
        }
        return true;
    }

    private void checkMethods(RoundEnvironment env, TypeElement type) {
        for (Element element : env.getElementsAnnotatedWith(type)) {
            ExecutableElement method;
            TypeMirror returned;
            if (element.getKind() != ElementKind.METHOD || (returned = (method = (ExecutableElement)element).getReturnType()).getKind().equals((Object)TypeKind.VOID) || this.assignableToFuture(returned)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Method '%s.%s' annotated with @Async does not return void or Future", method.getEnclosingElement().getSimpleName(), method.getSimpleName()));
        }
    }

    private boolean assignableToFuture(TypeMirror type) {
        Types types = this.processingEnv.getTypeUtils();
        return types.isAssignable(types.erasure(type), types.erasure(this.processingEnv.getElementUtils().getTypeElement(Future.class.getCanonicalName()).asType()));
    }
}

