/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListStyleShorthandResolver
implements IShorthandResolver {
    private static final Set<String> LIST_STYLE_TYPE_VALUES = new HashSet<String>(Arrays.asList("disc", "armenian", "circle", "cjk-ideographic", "decimal", "decimal-leading-zero", "georgian", "hebrew", "hiragana", "hiragana-iroha", "lower-alpha", "lower-greek", "lower-latin", "lower-roman", "none", "square", "upper-alpha", "upper-latin", "upper-roman"));
    private static final Set<String> LIST_STYLE_POSITION_VALUES = new HashSet<String>(Arrays.asList("inside", "outside"));

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if ("initial".equals(shorthandExpression) || "inherit".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("list-style-type", shorthandExpression), new CssDeclaration("list-style-position", shorthandExpression), new CssDeclaration("list-style-image", shorthandExpression));
        }
        String[] props = shorthandExpression.split("\\s+");
        String listStyleTypeValue = null;
        String listStylePositionValue = null;
        String listStyleImageValue = null;
        for (String value : props) {
            if (value.contains("url(") || "none".equals(value) && listStyleTypeValue != null) {
                listStyleImageValue = value;
                continue;
            }
            if (LIST_STYLE_TYPE_VALUES.contains(value)) {
                listStyleTypeValue = value;
                continue;
            }
            if (!LIST_STYLE_POSITION_VALUES.contains(value)) continue;
            listStylePositionValue = value;
        }
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        resolvedDecl.add(new CssDeclaration("list-style-type", listStyleTypeValue == null ? "initial" : listStyleTypeValue));
        resolvedDecl.add(new CssDeclaration("list-style-position", listStylePositionValue == null ? "initial" : listStylePositionValue));
        resolvedDecl.add(new CssDeclaration("list-style-image", listStyleImageValue == null ? "initial" : listStyleImageValue));
        return resolvedDecl;
    }
}

