/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.annotationsflattening;

import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.utils.annotationsflattening.AbstractTextMarkupAnnotationFlattener;

public class SquigglyTextMarkupAnnotationFlattener
extends AbstractTextMarkupAnnotationFlattener {
    private static final double HEIGHT = 1.0;
    private static final double ADVANCE = 1.0;

    @Override
    protected boolean draw(PdfAnnotation annotation, PdfPage page) {
        PdfCanvas under = this.createCanvas(page);
        float[] quadPoints = SquigglyTextMarkupAnnotationFlattener.getQuadPointsAsFloatArray(annotation);
        double baseLineHeight = (double)quadPoints[7] + 1.25;
        double maxHeight = baseLineHeight + 1.0;
        double minHeight = baseLineHeight - 1.0;
        double maxWidth = page.getPageSize().getWidth();
        double xCoordinate = quadPoints[4];
        double endX = quadPoints[6];
        under.saveState().setStrokeColor(this.getColor(annotation));
        while (xCoordinate <= endX && !(xCoordinate >= maxWidth)) {
            under.moveTo(xCoordinate, baseLineHeight);
            under.lineTo(xCoordinate += 1.0, maxHeight);
            under.lineTo(xCoordinate += 2.0, minHeight);
            under.lineTo(xCoordinate += 1.0, baseLineHeight);
            under.stroke();
        }
        under.restoreState();
        return true;
    }
}

