/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.cmap.CMapCidToCodepoint;
import com.itextpdf.io.font.cmap.CMapCodepointToCid;
import com.itextpdf.io.font.cmap.CMapLocationFromBytes;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.source.ByteBuffer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class CMapEncoding {
    private static final List<byte[]> IDENTITY_H_V_CODESPACE_RANGES = Arrays.asList({0, 0}, {-1, -1});
    private final String cmap;
    private String uniMap;
    private boolean isDirect;
    private CMapCidToCodepoint cid2Code;
    private CMapCodepointToCid code2Cid;
    private List<byte[]> codeSpaceRanges;

    public CMapEncoding(String cmap) {
        this.cmap = cmap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.isDirect = true;
        }
        this.codeSpaceRanges = IDENTITY_H_V_CODESPACE_RANGES;
    }

    public CMapEncoding(String cmap, String uniMap) {
        this.cmap = cmap;
        this.uniMap = uniMap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.isDirect = true;
            this.codeSpaceRanges = IDENTITY_H_V_CODESPACE_RANGES;
        } else {
            this.cid2Code = FontCache.getCidToCodepointCmap(cmap);
            this.code2Cid = CMapEncoding.getCodeToCidCmap(cmap, this.cid2Code);
            this.codeSpaceRanges = this.cid2Code.getCodeSpaceRanges();
        }
    }

    public CMapEncoding(String cmap, byte[] cmapBytes) {
        this.cmap = cmap;
        this.cid2Code = new CMapCidToCodepoint();
        try {
            CMapParser.parseCid(cmap, this.cid2Code, new CMapLocationFromBytes(cmapBytes));
            this.code2Cid = CMapEncoding.getCodeToCidCmap(cmap, this.cid2Code);
            this.codeSpaceRanges = this.cid2Code.getCodeSpaceRanges();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed to parse encoding stream.");
        }
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean hasUniMap() {
        return this.uniMap != null && this.uniMap.length() > 0;
    }

    public String getRegistry() {
        if (this.isDirect()) {
            return "Adobe";
        }
        return this.cid2Code.getRegistry();
    }

    public String getOrdering() {
        if (this.isDirect()) {
            return "Identity";
        }
        return this.cid2Code.getOrdering();
    }

    public int getSupplement() {
        if (this.isDirect()) {
            return 0;
        }
        return this.cid2Code.getSupplement();
    }

    public String getUniMapName() {
        return this.uniMap;
    }

    public String getCmapName() {
        return this.cmap;
    }

    public boolean isBuiltWith(String cmap) {
        return Objects.equals(cmap, this.cmap);
    }

    public byte[] getCmapBytes(int cid) {
        int length = this.getCmapBytesLength(cid);
        byte[] result = new byte[length];
        this.fillCmapBytes(cid, result, 0);
        return result;
    }

    public int fillCmapBytes(int cid, byte[] array, int offset) {
        if (this.isDirect) {
            array[offset++] = (byte)((cid & 0xFF00) >> 8);
            array[offset++] = (byte)(cid & 0xFF);
        } else {
            byte[] bytes = this.cid2Code.lookup(cid);
            for (int i = 0; i < bytes.length; ++i) {
                array[offset++] = bytes[i];
            }
        }
        return offset;
    }

    public void fillCmapBytes(int cid, ByteBuffer buffer) {
        if (this.isDirect) {
            buffer.append((byte)((cid & 0xFF00) >> 8));
            buffer.append((byte)(cid & 0xFF));
        } else {
            byte[] bytes = this.cid2Code.lookup(cid);
            buffer.append(bytes);
        }
    }

    public int getCmapBytesLength(int cid) {
        if (this.isDirect) {
            return 2;
        }
        return this.cid2Code.lookup(cid).length;
    }

    public int getCidCode(int cmapCode) {
        if (this.isDirect) {
            return cmapCode;
        }
        return this.code2Cid.lookup(cmapCode);
    }

    public List<byte[]> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    private static CMapCodepointToCid getCodeToCidCmap(String cmap, CMapCidToCodepoint cid2Code) {
        try {
            return FontCache.getCodepointToCidCmap(cmap);
        }
        catch (com.itextpdf.io.exceptions.IOException ex) {
            return new CMapCodepointToCid(cid2Code);
        }
    }
}

