/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.io.codec.Base64;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFormField
extends PdfObjectWrapper<PdfDictionary> {
    public static final int FF_MULTILINE = PdfFormField.makeFieldFlag(13);
    public static final int FF_PASSWORD = PdfFormField.makeFieldFlag(14);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int MIN_FONT_SIZE = 4;
    public static final int DA_FONT = 0;
    public static final int DA_SIZE = 1;
    public static final int DA_COLOR = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int TYPE_CHECK = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_CROSS = 3;
    public static final int TYPE_DIAMOND = 4;
    public static final int TYPE_SQUARE = 5;
    public static final int TYPE_STAR = 6;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int VISIBLE = 4;
    public static final int FF_READ_ONLY = PdfFormField.makeFieldFlag(1);
    public static final int FF_REQUIRED = PdfFormField.makeFieldFlag(2);
    public static final int FF_NO_EXPORT = PdfFormField.makeFieldFlag(3);
    public static final float X_OFFSET = 2.0f;
    protected static String[] typeChars = new String[]{"4", "l", "8", "u", "n", "H"};
    protected String text;
    protected ImageData img;
    protected PdfFont font;
    protected float fontSize = -1.0f;
    protected Color color;
    protected int checkType;
    protected float borderWidth = 0.0f;
    protected Color backgroundColor;
    protected Color borderColor;
    protected int rotation = 0;
    protected PdfFormXObject form;
    protected PdfAConformanceLevel pdfAConformanceLevel;
    protected static final String check = "0.8 0 0 0.8 0.3 0.5 cm 0 0 m\n0.066 -0.026 l\n0.137 -0.15 l\n0.259 0.081 0.46 0.391 0.553 0.461 c\n0.604 0.489 l\n0.703 0.492 l\n0.543 0.312 0.255 -0.205 0.154 -0.439 c\n0.069 -0.399 l\n0.035 -0.293 -0.039 -0.136 -0.091 -0.057 c\nh\nf\n";
    protected static final String circle = "1 0 0 1 0.86 0.5 cm 0 0 m\n0 0.204 -0.166 0.371 -0.371 0.371 c\n-0.575 0.371 -0.741 0.204 -0.741 0 c\n-0.741 -0.204 -0.575 -0.371 -0.371 -0.371 c\n-0.166 -0.371 0 -0.204 0 0 c\nf\n";
    protected static final String cross = "1 0 0 1 0.80 0.8 cm 0 0 m\n-0.172 -0.027 l\n-0.332 -0.184 l\n-0.443 -0.019 l\n-0.475 -0.009 l\n-0.568 -0.168 l\n-0.453 -0.324 l\n-0.58 -0.497 l\n-0.59 -0.641 l\n-0.549 -0.627 l\n-0.543 -0.612 -0.457 -0.519 -0.365 -0.419 c\n-0.163 -0.572 l\n-0.011 -0.536 l\n-0.004 -0.507 l\n-0.117 -0.441 l\n-0.246 -0.294 l\n-0.132 -0.181 l\n0.031 -0.04 l\nh\nf\n";
    protected static final String diamond = "1 0 0 1 0.5 0.12 cm 0 0 m\n0.376 0.376 l\n0 0.751 l\n-0.376 0.376 l\nh\nf\n";
    protected static final String square = "1 0 0 1 0.835 0.835 cm 0 0 -0.669 -0.67 re\nf\n";
    protected static final String star = "0.95 0 0 0.95 0.85 0.6 cm 0 0 m\n-0.291 0 l\n-0.381 0.277 l\n-0.47 0 l\n-0.761 0 l\n-0.526 -0.171 l\n-0.616 -0.448 l\n-0.381 -0.277 l\n-0.145 -0.448 l\n-0.236 -0.171 l\nh\nf\n";

    public PdfFormField(PdfDictionary pdfObject) {
        super((PdfObject)pdfObject);
        PdfFormField.ensureObjectIsAddedToDocument((PdfObject)pdfObject);
        this.setForbidRelease();
    }

    protected PdfFormField(PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        PdfName formType = this.getFormType();
        if (formType != null) {
            this.put(PdfName.FT, (PdfObject)formType);
        }
    }

    protected PdfFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        widget.makeIndirect(pdfDocument);
        this.addKid(widget);
        this.put(PdfName.FT, (PdfObject)this.getFormType());
    }

    public static int makeFieldFlag(int bitPosition) {
        return 1 << bitPosition - 1;
    }

    public static PdfFormField createEmptyField(PdfDocument doc) {
        return PdfFormField.createEmptyField(doc, null);
    }

    public static PdfFormField createEmptyField(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfFormField field = new PdfFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        return field;
    }

    public static PdfButtonFormField createButton(PdfDocument doc, Rectangle rect, int flags) {
        return PdfFormField.createButton(doc, rect, flags, null);
    }

    public static PdfButtonFormField createButton(PdfDocument doc, Rectangle rect, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfButtonFormField createButton(PdfDocument doc, int flags) {
        return PdfFormField.createButton(doc, flags, null);
    }

    public static PdfButtonFormField createButton(PdfDocument doc, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfButtonFormField field = new PdfButtonFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfTextFormField createText(PdfDocument doc) {
        return PdfFormField.createText(doc, (PdfAConformanceLevel)null);
    }

    public static PdfTextFormField createText(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfTextFormField textFormField = new PdfTextFormField(doc);
        textFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        return textFormField;
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        return new PdfTextFormField(annot, doc);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name) {
        return PdfFormField.createText(doc, rect, name, "");
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value) {
        try {
            return PdfFormField.createText(doc, rect, name, value, PdfFontFactory.createFont(), 12.0f);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, false);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, boolean multiline) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, multiline, null);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, boolean multiline, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfTextFormField field = new PdfTextFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.setMultiline(multiline);
        field.font = font;
        field.fontSize = fontSize;
        field.setValue(value);
        field.setFieldName(name);
        return field;
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, true);
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value) {
        try {
            return PdfFormField.createText(doc, rect, name, value, PdfFontFactory.createFont(), 12.0f, true);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, int flags) {
        return PdfFormField.createChoice(doc, flags, null);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfChoiceFormField field = new PdfChoiceFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, int flags) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfArray options, int flags) {
        try {
            return PdfFormField.createChoice(doc, rect, name, value, PdfFontFactory.createFont(), 12.0f, options, flags);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfArray options, int flags, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, font, 12.0f, options, flags, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, PdfArray options, int flags) {
        return PdfFormField.createChoice(doc, rect, name, value, font, fontSize, options, flags, null);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, PdfArray options, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.font = font;
        field.fontSize = fontSize;
        field.put(PdfName.Opt, (PdfObject)options);
        field.setFieldFlags(flags);
        field.setFieldName(name);
        ((PdfDictionary)field.getPdfObject()).put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        if ((flags & PdfChoiceFormField.FF_COMBO) == 0) {
            value = PdfFormField.optionsArrayToString(options);
        }
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        field.drawMultiLineTextAppearance(rect, font, fontSize, value, xObject);
        xObject.getResources().addFont(doc, font);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        return field;
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc) {
        return PdfFormField.createSignature(doc, (PdfAConformanceLevel)null);
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfSignatureFormField signatureFormField = new PdfSignatureFormField(doc);
        signatureFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        return signatureFormField;
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, Rectangle rect) {
        return PdfFormField.createSignature(doc, rect, null);
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, Rectangle rect, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfSignatureFormField signatureFormField = new PdfSignatureFormField(annot, doc);
        signatureFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        return signatureFormField;
    }

    public static PdfButtonFormField createRadioGroup(PdfDocument doc, String name, String value) {
        return PdfFormField.createRadioGroup(doc, name, value, null);
    }

    public static PdfButtonFormField createRadioGroup(PdfDocument doc, String name, String value, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfButtonFormField radio = PdfFormField.createButton(doc, PdfButtonFormField.FF_RADIO);
        radio.setFieldName(name);
        radio.put(PdfName.V, (PdfObject)new PdfName(value));
        radio.pdfAConformanceLevel = pdfAConformanceLevel;
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        String name = radioGroup.getValue().toString().substring(1);
        if (name.equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value, PdfAConformanceLevel pdfAConformanceLevel) {
        String name;
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        radio.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        if ((name = radioGroup.getValue().toString().substring(1)).equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        if (pdfAConformanceLevel != null && "1".equals(pdfAConformanceLevel.getPart())) {
            radio.drawPdfA1RadioAppearance(rect.getWidth(), rect.getHeight(), value);
        } else {
            radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        }
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption) {
        PdfButtonFormField field;
        try {
            field = PdfFormField.createPushButton(doc, rect, name, caption, PdfFontFactory.createFont(), 12.0f);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
        return field;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption, PdfFont font, float fontSize) {
        return PdfFormField.createPushButton(doc, rect, name, caption, font, fontSize, null);
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption, PdfFont font, float fontSize, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.setPushButton(true);
        field.setFieldName(name);
        field.text = caption;
        field.font = font;
        field.fontSize = fontSize;
        PdfFormXObject xObject = field.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), caption, font, fontSize);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(caption));
        mk.put(PdfName.BG, (PdfObject)new PdfArray(field.backgroundColor.getColorValue()));
        annot.setAppearanceCharacteristics(mk);
        return field;
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value) {
        return PdfFormField.createCheckBox(doc, rect, name, value, 3);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType) {
        return PdfFormField.createCheckBox(doc, rect, name, value, checkType, null);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType, PdfAConformanceLevel pdfAConformanceLevel) {
        String pdfAVersion;
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField check = new PdfButtonFormField(annot, doc);
        check.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        check.setCheckType(checkType);
        check.setFieldName(name);
        check.put(PdfName.V, (PdfObject)new PdfName(value));
        annot.setAppearanceState(new PdfName(value));
        switch (pdfAVersion = pdfAConformanceLevel != null ? pdfAConformanceLevel.getPart() : "") {
            case "1": {
                check.drawPdfA1CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
                break;
            }
            case "2": {
                check.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
                break;
            }
            case "3": {
                check.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
                break;
            }
            default: {
                check.drawCheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value);
            }
        }
        return check;
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        try {
            return PdfFormField.createComboBox(doc, rect, name, value, options, PdfFontFactory.createFont(), null);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[][] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        try {
            return PdfFormField.createComboBox(doc, rect, name, value, options, PdfFontFactory.createFont(), null);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        try {
            return PdfFormField.createList(doc, rect, name, value, options, PdfFontFactory.createFont(), null);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[][] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        try {
            return PdfFormField.createList(doc, rect, name, value, options, PdfFontFactory.createFont(), null);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0, font, pdfAConformanceLevel);
    }

    public static PdfFormField makeFormField(PdfObject pdfObject, PdfDocument document) {
        PdfFormField field = null;
        if (pdfObject.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)pdfObject;
            PdfName formType = dictionary.getAsName(PdfName.FT);
            field = PdfName.Tx.equals((Object)formType) ? new PdfTextFormField(dictionary) : (PdfName.Btn.equals((Object)formType) ? new PdfButtonFormField(dictionary) : (PdfName.Ch.equals((Object)formType) ? new PdfChoiceFormField(dictionary) : (PdfName.Sig.equals((Object)formType) ? new PdfSignatureFormField(dictionary) : new PdfFormField(dictionary))));
        }
        if (field != null) {
            field.makeIndirect(document);
            if (document != null && document.getReader() != null && document.getReader().getPdfAConformanceLevel() != null) {
                field.pdfAConformanceLevel = document.getReader().getPdfAConformanceLevel();
            }
        }
        return field;
    }

    public PdfName getFormType() {
        return this.getTypeFromParent((PdfDictionary)this.getPdfObject());
    }

    public PdfFormField setValue(String value) {
        PdfArray kids;
        PdfName ft = this.getFormType();
        if (!(ft != null && ft.equals((Object)PdfName.Btn) || (kids = this.getKids()) == null)) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                PdfFormField field = new PdfFormField((PdfDictionary)kid);
                field.font = this.font;
                field.fontSize = this.fontSize;
                field.setValue(value);
            }
        }
        return this.setValue(value, true);
    }

    public PdfFormField setValue(String value, boolean generateAppearance) {
        PdfName formType = this.getFormType();
        if (PdfName.Tx.equals((Object)formType) || PdfName.Ch.equals((Object)formType)) {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        } else if (PdfName.Btn.equals((Object)formType)) {
            if ((this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                try {
                    this.img = ImageDataFactory.create((byte[])Base64.decode((String)value));
                }
                catch (Exception e) {
                    this.text = value;
                }
            } else {
                this.put(PdfName.V, (PdfObject)new PdfName(value));
                for (String as : this.getAppearanceStates()) {
                    if (!as.equals(value)) continue;
                    this.put(PdfName.AS, (PdfObject)new PdfName(value));
                    break;
                }
            }
        } else {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        }
        if (generateAppearance) {
            this.regenerateField();
        }
        this.setModified();
        return this;
    }

    public PdfFormField setValue(String value, PdfFont font, float fontSize) {
        PdfName formType = this.getFormType();
        if (!formType.equals((Object)PdfName.Tx) && !formType.equals((Object)PdfName.Ch)) {
            return this.setValue(value);
        }
        PdfArray bBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect);
        if (bBox == null) {
            PdfArray kids = this.getKids();
            if (kids == null) {
                throw new PdfException("Wrong form field. Add annotation to the field.");
            }
            bBox = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
        }
        PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()));
        if (formType.equals((Object)PdfName.Tx)) {
            this.drawTextAppearance(bBox.toRectangle(), font, fontSize, value, appearance);
        } else {
            this.drawMultiLineTextAppearance(bBox.toRectangle(), font, fontSize, value, appearance);
        }
        appearance.getResources().addFont(this.getDocument(), font);
        PdfDictionary ap = new PdfDictionary();
        ap.put(PdfName.N, appearance.getPdfObject());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        return this.put(PdfName.AP, (PdfObject)ap);
    }

    public PdfFormField setValue(String value, String display) {
        if (display == null) {
            return this.setValue(value);
        }
        this.setValue(display, true);
        PdfName formType = this.getFormType();
        if (PdfName.Tx.equals((Object)formType) || PdfName.Ch.equals((Object)formType)) {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        } else if (PdfName.Btn.equals((Object)formType)) {
            if ((this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                this.text = value;
            } else {
                this.put(PdfName.V, (PdfObject)new PdfName(value));
            }
        } else {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        }
        return this;
    }

    public PdfFormField setParent(PdfFormField parent) {
        return this.put(PdfName.Parent, parent.getPdfObject());
    }

    public PdfDictionary getParent() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Parent);
    }

    public PdfArray getKids() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Kids);
    }

    public PdfFormField addKid(PdfFormField kid) {
        kid.setParent(this);
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add(kid.getPdfObject());
        return this.put(PdfName.Kids, (PdfObject)kids);
    }

    public PdfFormField addKid(PdfWidgetAnnotation kid) {
        kid.setParent(this.getPdfObject());
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add(kid.getPdfObject());
        return this.put(PdfName.Kids, (PdfObject)kids);
    }

    public PdfFormField setFieldName(String name) {
        return this.put(PdfName.T, (PdfObject)new PdfString(name));
    }

    public PdfString getFieldName() {
        PdfString name;
        PdfFormField parentField;
        PdfString pName;
        String parentName = "";
        PdfDictionary parent = this.getParent();
        if (parent != null && (pName = (parentField = PdfFormField.makeFormField((PdfObject)this.getParent(), this.getDocument())).getFieldName()) != null) {
            parentName = pName.toUnicodeString() + ".";
        }
        if ((name = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T)) != null) {
            name = new PdfString(parentName + name.toUnicodeString(), "UnicodeBig");
        }
        return name;
    }

    public PdfFormField setAlternativeName(String name) {
        return this.put(PdfName.TU, (PdfObject)new PdfString(name));
    }

    public PdfString getAlternativeName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TU);
    }

    public PdfFormField setMappingName(String name) {
        return this.put(PdfName.TM, (PdfObject)new PdfString(name));
    }

    public PdfString getMappingName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TM);
    }

    public boolean getFieldFlag(int flag) {
        return (this.getFieldFlags() & flag) != 0;
    }

    public PdfFormField setFieldFlag(int flag) {
        return this.setFieldFlag(flag, true);
    }

    public PdfFormField setFieldFlag(int flag, boolean value) {
        int flags = this.getFieldFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        return this.setFieldFlags(flags);
    }

    public boolean isMultiline() {
        return this.getFieldFlag(FF_MULTILINE);
    }

    public boolean isPassword() {
        return this.getFieldFlag(FF_PASSWORD);
    }

    public PdfFormField setFieldFlags(int flags) {
        return this.put(PdfName.Ff, (PdfObject)new PdfNumber(flags));
    }

    public int getFieldFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Ff);
        if (f != null) {
            return f.intValue();
        }
        PdfDictionary parent = this.getParent();
        if (parent != null) {
            return new PdfFormField(parent).getFieldFlags();
        }
        return 0;
    }

    public PdfObject getValue() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
    }

    public String getValueAsString() {
        PdfObject value = ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
        if (value == null) {
            return "";
        }
        if (value instanceof PdfStream) {
            return new String(((PdfStream)value).getBytes());
        }
        if (value instanceof PdfName) {
            return ((PdfName)value).getValue();
        }
        if (value instanceof PdfString) {
            return ((PdfString)value).toUnicodeString();
        }
        return "";
    }

    public PdfFormField setDefaultValue(PdfObject value) {
        return this.put(PdfName.DV, value);
    }

    public PdfObject getDefaultValue() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.DV);
    }

    public PdfFormField setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction((PdfObjectWrapper)this, (PdfName)key, (PdfAction)action);
        return this;
    }

    public PdfDictionary getAdditionalAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AA);
    }

    public PdfFormField setOptions(PdfArray options) {
        return this.put(PdfName.Opt, (PdfObject)options);
    }

    public PdfArray getOptions() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
    }

    public List<PdfWidgetAnnotation> getWidgets() {
        PdfArray kids;
        ArrayList<PdfWidgetAnnotation> widgets = new ArrayList<PdfWidgetAnnotation>();
        PdfName subType = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
        if (subType != null && subType.equals((Object)PdfName.Widget)) {
            widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)this.getPdfObject()));
        }
        if ((kids = this.getKids()) != null) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                subType = ((PdfDictionary)kid).getAsName(PdfName.Subtype);
                if (subType == null || !subType.equals((Object)PdfName.Widget)) continue;
                widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)kid));
            }
        }
        return widgets;
    }

    public PdfString getDefaultAppearance() {
        PdfDictionary parent;
        PdfString defaultAppearance = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
        if (defaultAppearance == null && (parent = this.getParent()) != null && parent.containsKey(PdfName.FT)) {
            defaultAppearance = parent.getAsString(PdfName.DA);
        }
        return defaultAppearance;
    }

    public PdfFormField setDefaultAppearance(String defaultAppearance) {
        byte[] b = defaultAppearance.getBytes(StandardCharsets.UTF_8);
        int len = b.length;
        for (int k = 0; k < len; ++k) {
            if (b[k] != 10) continue;
            b[k] = 32;
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.DA, (PdfObject)new PdfString(new String(b)));
        return this;
    }

    public Integer getJustification() {
        return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.Q);
    }

    public PdfFormField setJustification(int justification) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Q, (PdfObject)new PdfNumber(justification));
        this.regenerateField();
        return this;
    }

    public PdfString getDefaultStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DS);
    }

    public PdfFormField setDefaultStyle(PdfString defaultStyleString) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.DS, (PdfObject)defaultStyleString);
        return this;
    }

    public PdfObject getRichText() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.RV);
    }

    public PdfFormField setRichText(PdfObject richText) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.RV, richText);
        return this;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public PdfFormField setFont(PdfFont font) {
        this.font = font;
        this.regenerateField();
        return this;
    }

    public PdfFormField setFontSize(float fontSize) {
        this.fontSize = fontSize;
        this.regenerateField();
        return this;
    }

    public PdfFormField setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
        return this;
    }

    public PdfFormField setFontAndSize(PdfFont font, int fontSize) {
        this.font = font;
        this.fontSize = fontSize;
        this.regenerateField();
        return this;
    }

    public PdfFormField setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        mk.put(PdfName.BG, (PdfObject)new PdfArray(backgroundColor.getColorValue()));
        this.regenerateField();
        return this;
    }

    public PdfFormField setRotation(int degRotation) {
        if (degRotation % 90 != 0) {
            throw new IllegalArgumentException("degRotation.must.be.a.multiple.of.90");
        }
        if ((degRotation %= 360) < 0) {
            degRotation += 360;
        }
        this.rotation = degRotation;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, (PdfObject)mk);
        }
        mk.put(PdfName.R, (PdfObject)new PdfNumber(degRotation));
        this.rotation = degRotation;
        this.regenerateField();
        return this;
    }

    public PdfFormField setAction(PdfAction action) {
        List<PdfWidgetAnnotation> widgets = this.getWidgets();
        if (widgets != null) {
            for (PdfWidgetAnnotation widget : widgets) {
                widget.setAction(action);
            }
        }
        return this;
    }

    public PdfFormField setCheckType(int checkType) {
        if (checkType < 1 || checkType > 6) {
            checkType = 3;
        }
        this.checkType = checkType;
        this.text = typeChars[checkType - 1];
        if (this.pdfAConformanceLevel != null) {
            return this;
        }
        try {
            this.font = PdfFontFactory.createFont((String)"ZapfDingbats");
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
        return this;
    }

    public PdfFormField setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, (PdfObject)new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, (PdfObject)new PdfNumber(36));
                break;
            }
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, (PdfObject)new PdfNumber(4));
            }
        }
        return this;
    }

    public boolean regenerateField() {
        PdfName type = this.getFormType();
        String value = this.getValueAsString();
        PdfPage page = null;
        if (this.getWidgets().size() > 0) {
            page = this.getWidgets().get(0).getPage();
        }
        if (PdfName.Tx.equals((Object)type) || PdfName.Ch.equals((Object)type)) {
            try {
                PdfArray matrix;
                double translationHeight;
                double translationWidth;
                PdfArray bBox;
                PdfDictionary apDic = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
                PdfStream asNormal = null;
                if (apDic != null) {
                    asNormal = apDic.getAsStream(PdfName.N);
                }
                if ((bBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect)) == null) {
                    PdfArray kids = this.getKids();
                    if (kids == null) {
                        throw new PdfException("Wrong form field. Add annotation to the field.");
                    }
                    bBox = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
                }
                Object[] fontAndSize = this.getFontAndSize((PdfDictionary)asNormal);
                PdfFont localFont = (PdfFont)fontAndSize[0];
                float fontSize = this.normalizeFontSize(((Float)fontAndSize[1]).floatValue(), localFont, bBox, value);
                int pageRotation = 0;
                if (page != null) {
                    pageRotation = page.getRotation();
                    pageRotation *= -1;
                }
                if (pageRotation % 90 == 0) {
                    double angle = pageRotation % 360;
                    angle = PdfFormField.degreeToRadians(angle);
                    Rectangle rect = bBox.toRectangle();
                    translationWidth = 0.0;
                    translationHeight = 0.0;
                    if (angle >= -Math.PI && angle <= -1.5707963267948966) {
                        translationWidth = rect.getWidth();
                    }
                    if (angle <= -Math.PI) {
                        translationHeight = rect.getHeight();
                    }
                    matrix = new PdfArray(new double[]{Math.cos(angle), -Math.sin(angle), Math.sin(angle), Math.cos(angle), translationWidth, translationHeight});
                    if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                        rect.setWidth(bBox.toRectangle().getHeight());
                        rect.setHeight(bBox.toRectangle().getWidth());
                    }
                    rect.setX(rect.getX() + (float)translationWidth);
                    rect.setY(rect.getY() + (float)translationHeight);
                    bBox = new PdfArray(rect);
                } else {
                    Logger logger = LoggerFactory.getLogger(PdfFormField.class);
                    logger.error("Encounterd a page rotation that was not a multiple of 90\u00b0/ (Pi/2) when generating default appearances for form fields");
                    matrix = new PdfArray(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
                }
                float fieldRotation = 0.0f;
                if (((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK) != null && ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK).get(PdfName.R) != null) {
                    fieldRotation = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK).getAsFloat(PdfName.R).floatValue();
                    fieldRotation += (float)pageRotation;
                }
                if (fieldRotation % 90.0f == 0.0f) {
                    double angle = fieldRotation % 360.0f;
                    angle = PdfFormField.degreeToRadians(angle);
                    translationWidth = this.calculateTranslationWidthAfterFieldRot(bBox.toRectangle(), PdfFormField.degreeToRadians(pageRotation), angle);
                    translationHeight = this.calculateTranslationHeightAfterFieldRot(bBox.toRectangle(), PdfFormField.degreeToRadians(pageRotation), angle);
                    Matrix currentMatrix = new Matrix(matrix.getAsNumber(0).floatValue(), matrix.getAsNumber(1).floatValue(), matrix.getAsNumber(2).floatValue(), matrix.getAsNumber(3).floatValue(), matrix.getAsNumber(4).floatValue(), matrix.getAsNumber(5).floatValue());
                    Matrix toConcatenate = new Matrix((float)Math.cos(angle), (float)(-Math.sin(angle)), (float)Math.sin(angle), (float)Math.cos(angle), (float)translationWidth, (float)translationHeight);
                    currentMatrix = currentMatrix.multiply(toConcatenate);
                    matrix = new PdfArray(new float[]{currentMatrix.get(0), currentMatrix.get(1), currentMatrix.get(3), currentMatrix.get(4), currentMatrix.get(6), currentMatrix.get(7)});
                    Rectangle rect = bBox.toRectangle();
                    if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                        rect.setWidth(bBox.toRectangle().getHeight());
                        rect.setHeight(bBox.toRectangle().getWidth());
                    }
                    rect.setX(rect.getX() + (float)translationWidth);
                    rect.setY(rect.getY() + (float)translationHeight);
                    bBox = new PdfArray(rect);
                }
                PdfFormXObject appearance = null;
                if (asNormal != null) {
                    appearance = new PdfFormXObject(asNormal);
                    appearance.setBBox(new PdfArray(new float[]{0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()}));
                }
                if (appearance == null) {
                    appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()));
                }
                if (matrix != null) {
                    appearance.put(PdfName.Matrix, (PdfObject)matrix);
                }
                if (PdfName.Tx.equals((Object)type)) {
                    if (!this.isMultiline()) {
                        this.drawTextAppearance(bBox.toRectangle(), localFont, fontSize, value, appearance);
                    } else {
                        this.drawMultiLineTextAppearance(bBox.toRectangle(), localFont, fontSize, value, appearance);
                    }
                } else {
                    if (!this.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                        PdfNumber topIndex = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.TI);
                        PdfArray options = this.getOptions();
                        if (null != options) {
                            PdfArray visibleOptions = null != topIndex ? new PdfArray(options.subList(topIndex.intValue(), options.size() - 1)) : (PdfArray)options.clone();
                            value = PdfFormField.optionsArrayToString(visibleOptions);
                        }
                    }
                    this.drawMultiLineTextAppearance(bBox.toRectangle(), localFont, fontSize, value, appearance);
                }
                appearance.getResources().addFont(this.getDocument(), localFont);
                appearance.setModified();
                PdfDictionary ap = new PdfDictionary();
                ap.put(PdfName.N, appearance.getPdfObject());
                ap.setModified();
                this.put(PdfName.AP, (PdfObject)ap);
                return true;
            }
            catch (IOException e) {
                throw new PdfException((Throwable)e);
            }
        }
        if (PdfName.Btn.equals((Object)type)) {
            int ff = this.getFieldFlags();
            if ((ff & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                try {
                    PdfFormXObject appearance;
                    List<PdfWidgetAnnotation> widgets;
                    value = this.text;
                    Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
                    PdfDictionary apDic = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
                    if (apDic == null && (widgets = this.getWidgets()).size() == 1) {
                        apDic = ((PdfDictionary)widgets.get(0).getPdfObject()).getAsDictionary(PdfName.AP);
                    }
                    if (this.img != null) {
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, null, 0.0f);
                    } else if (this.form != null) {
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, null, 0.0f);
                    } else {
                        PdfStream asNormal = null;
                        if (apDic != null) {
                            asNormal = apDic.getAsStream(PdfName.N);
                        }
                        Object[] fontAndSize = this.getFontAndSize((PdfDictionary)asNormal);
                        PdfFont localFont = (PdfFont)fontAndSize[0];
                        float fontSize = ((Float)fontAndSize[1]).floatValue();
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, localFont, fontSize);
                        appearance.getResources().addFont(this.getDocument(), localFont);
                    }
                    if (apDic == null) {
                        apDic = new PdfDictionary();
                        this.put(PdfName.AP, (PdfObject)apDic);
                    }
                    apDic.put(PdfName.N, appearance.getPdfObject());
                }
                catch (IOException e) {
                    throw new PdfException((Throwable)e);
                }
            } else if ((ff & PdfButtonFormField.FF_RADIO) != 0) {
                PdfArray kids = this.getKids();
                if (null != kids) {
                    for (int i = 0; i < kids.size(); ++i) {
                        PdfObject kid = kids.get(i);
                        PdfFormField field = new PdfFormField((PdfDictionary)kid);
                        PdfWidgetAnnotation widget = field.getWidgets().get(0);
                        PdfDictionary buttonValues = (PdfDictionary)((PdfDictionary)field.getPdfObject()).getAsDictionary(PdfName.AP).get(PdfName.N);
                        String state = buttonValues.get(new PdfName(value)) != null ? value : "Off";
                        widget.setAppearanceState(new PdfName(state));
                    }
                }
            } else {
                String pdfAVersion;
                Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
                this.setCheckType(this.checkType);
                switch (pdfAVersion = this.pdfAConformanceLevel != null ? this.pdfAConformanceLevel.getPart() : "") {
                    case "1": {
                        this.drawPdfA1CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                        break;
                    }
                    case "2": {
                        this.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                        break;
                    }
                    case "3": {
                        this.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                        break;
                    }
                    default: {
                        this.drawCheckAppearance(rect.getWidth(), rect.getHeight(), value);
                    }
                }
                PdfWidgetAnnotation widget = this.getWidgets().get(0);
                if (widget.getNormalAppearanceObject() != null && widget.getNormalAppearanceObject().containsKey(new PdfName(value))) {
                    widget.setAppearanceState(new PdfName(value));
                } else {
                    widget.setAppearanceState(new PdfName("Off"));
                }
            }
        }
        return true;
    }

    private float normalizeFontSize(float fs, PdfFont localFont, PdfArray bBox, String value) {
        if (fs == 0.0f) {
            if (this.isMultiline()) {
                this.fontSize = 12.0f;
            } else {
                float height = bBox.toRectangle().getHeight() - this.borderWidth * 2.0f;
                int[] fontBbox = localFont.getFontProgram().getFontMetrics().getBbox();
                fs = height / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f;
                float baseWidth = localFont.getWidth(value, 1.0f);
                float offsetX = Math.max(this.borderWidth + 2.0f, 1.0f);
                if (baseWidth != 0.0f) {
                    fs = Math.min(fs, (bBox.toRectangle().getWidth() - 4.0f * offsetX) / baseWidth);
                }
            }
        }
        if (fs < 4.0f) {
            fs = 4.0f;
        }
        return fs;
    }

    private float calculateTranslationHeightAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0) {
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getHeight();
            }
        }
        if (pageRotation == -1.5707963267948966) {
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth() - bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight() - bBox.getWidth();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    private float calculateTranslationWidthAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0 && (relFieldRotation == Math.PI || relFieldRotation == 4.71238898038469)) {
            return bBox.getWidth();
        }
        if (pageRotation == -1.5707963267948966 && (relFieldRotation == -1.5707963267948966 || relFieldRotation == Math.PI)) {
            return bBox.getHeight();
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return -1.0f * (bBox.getHeight() - bBox.getWidth());
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return -1.0f * (bBox.getWidth() - bBox.getHeight());
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    public float getBorderWidth() {
        PdfNumber w;
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (bs != null && (w = bs.getAsNumber(PdfName.W)) != null) {
            this.borderWidth = w.floatValue();
        }
        return this.borderWidth;
    }

    public PdfFormField setBorderWidth(float borderWidth) {
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (bs == null) {
            bs = new PdfDictionary();
            this.put(PdfName.BS, (PdfObject)bs);
        }
        bs.put(PdfName.W, (PdfObject)new PdfNumber((double)borderWidth));
        this.borderWidth = borderWidth;
        this.regenerateField();
        return this;
    }

    public PdfFormField setBorderStyle(PdfDictionary style) {
        this.getWidgets().get(0).setBorderStyle(style);
        this.regenerateField();
        return this;
    }

    public PdfFormField setBorderColor(Color color) {
        this.borderColor = color;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, (PdfObject)mk);
        }
        mk.put(PdfName.BC, (PdfObject)new PdfArray(color.getColorValue()));
        this.regenerateField();
        return this;
    }

    public PdfFormField setColor(Color color) {
        this.color = color;
        this.regenerateField();
        return this;
    }

    public PdfFormField setReadOnly(boolean readOnly) {
        return this.setFieldFlag(FF_READ_ONLY, readOnly);
    }

    public boolean isReadOnly() {
        return this.getFieldFlag(FF_READ_ONLY);
    }

    public PdfFormField setRequired(boolean required) {
        return this.setFieldFlag(FF_REQUIRED, required);
    }

    public boolean isRequired() {
        return this.getFieldFlag(FF_REQUIRED);
    }

    public PdfFormField setNoExport(boolean noExport) {
        return this.setFieldFlag(FF_NO_EXPORT, noExport);
    }

    public boolean isNoExport() {
        return this.getFieldFlag(FF_NO_EXPORT);
    }

    public PdfFormField setPage(int pageNum) {
        PdfAnnotation annot;
        if (this.getWidgets().size() > 0 && (annot = (PdfAnnotation)this.getWidgets().get(0)) != null) {
            annot.setPage(this.getDocument().getPage(pageNum));
        }
        return this;
    }

    public String[] getAppearanceStates() {
        PdfArray kids;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfString stringOpt = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Opt);
        if (stringOpt != null) {
            names.add(stringOpt.toUnicodeString());
        } else {
            PdfArray arrayOpt = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
            if (arrayOpt != null) {
                for (PdfObject pdfObject : arrayOpt) {
                    PdfString valStr = null;
                    if (pdfObject.isArray()) {
                        valStr = ((PdfArray)pdfObject).getAsString(1);
                    } else if (pdfObject.isString()) {
                        valStr = (PdfString)pdfObject;
                    }
                    if (valStr == null) continue;
                    names.add(valStr.toUnicodeString());
                }
            }
        }
        PdfDictionary dic = (PdfDictionary)this.getPdfObject();
        dic = dic.getAsDictionary(PdfName.AP);
        if (dic != null && (dic = dic.getAsDictionary(PdfName.N)) != null) {
            for (PdfName state : dic.keySet()) {
                names.add(state.getValue());
            }
        }
        if ((kids = this.getKids()) != null) {
            for (PdfObject kid : kids) {
                String[] states;
                PdfFormField fld = new PdfFormField((PdfDictionary)kid);
                for (String state : states = fld.getAppearanceStates()) {
                    names.add(state);
                }
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public PdfFormField setAppearance(PdfName appearanceType, String appearanceState, PdfStream appearanceStream) {
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        PdfDictionary dic = widget != null ? (PdfDictionary)widget.getPdfObject() : (PdfDictionary)this.getPdfObject();
        PdfDictionary ap = dic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            PdfDictionary appearanceDictionary = ap.getAsDictionary(appearanceType);
            if (appearanceDictionary == null) {
                ap.put(appearanceType, (PdfObject)appearanceStream);
            } else {
                appearanceDictionary.put(new PdfName(appearanceState), (PdfObject)appearanceStream);
            }
        }
        return this;
    }

    public PdfFormField setFontSizeAutoScale() {
        this.fontSize = 0.0f;
        this.regenerateField();
        return this;
    }

    public PdfFormField put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public void release() {
        this.unsetForbidRelease();
        ((PdfDictionary)this.getPdfObject()).release();
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    protected Rectangle getRect(PdfDictionary field) {
        PdfArray rect = field.getAsArray(PdfName.Rect);
        if (rect == null) {
            PdfArray kids = field.getAsArray(PdfName.Kids);
            if (kids == null) {
                throw new PdfException("Wrong form field. Add annotation to the field.");
            }
            rect = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
        }
        return rect.toRectangle();
    }

    protected static PdfArray processOptions(String[][] options) {
        PdfArray array = new PdfArray();
        for (String[] option : options) {
            PdfArray subArray = new PdfArray((PdfObject)new PdfString(option[0], "UnicodeBig"));
            subArray.add((PdfObject)new PdfString(option[1], "UnicodeBig"));
            array.add((PdfObject)subArray);
        }
        return array;
    }

    protected static PdfArray processOptions(String[] options) {
        PdfArray array = new PdfArray();
        for (String option : options) {
            array.add((PdfObject)new PdfString(option, "UnicodeBig"));
        }
        return array;
    }

    protected String generateDefaultAppearanceString(PdfFont font, float fontSize, Color color, PdfResources res) {
        PdfStream stream = new PdfStream();
        PdfCanvas canvas = new PdfCanvas(stream, res, this.getDocument());
        canvas.setFontAndSize(font, fontSize);
        if (color != null) {
            canvas.setColor(color, true);
        }
        return new String(stream.getBytes());
    }

    protected Object[] getFontAndSize(PdfDictionary asNormal) throws IOException {
        PdfDictionary acroformDictionary;
        Object[] fontAndSize = new Object[2];
        PdfDictionary normalResources = null;
        PdfDictionary defaultResources = null;
        PdfDocument document = this.getDocument();
        if (document != null && (acroformDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm)) != null) {
            defaultResources = acroformDictionary.getAsDictionary(PdfName.DR);
        }
        if (asNormal != null) {
            normalResources = asNormal.getAsDictionary(PdfName.Resources);
        }
        if (defaultResources != null || normalResources != null) {
            PdfDictionary normalFontDic = normalResources != null ? normalResources.getAsDictionary(PdfName.Font) : null;
            PdfDictionary defaultFontDic = defaultResources != null ? defaultResources.getAsDictionary(PdfName.Font) : null;
            PdfString defaultAppearance = this.getDefaultAppearance();
            if ((normalFontDic != null || defaultFontDic != null) && defaultAppearance != null) {
                Object[] dab = PdfFormField.splitDAelements(defaultAppearance.toUnicodeString());
                PdfName fontName = new PdfName(dab[0].toString());
                PdfDictionary requiredFontDictionary = null;
                if (normalFontDic != null && null != normalFontDic.getAsDictionary(fontName)) {
                    requiredFontDictionary = normalFontDic.getAsDictionary(fontName);
                } else if (defaultFontDic != null) {
                    requiredFontDictionary = defaultFontDic.getAsDictionary(fontName);
                }
                if (this.font != null) {
                    fontAndSize[0] = this.font;
                } else {
                    PdfFont dicFont = document != null ? document.getFont(requiredFontDictionary) : PdfFontFactory.createFont((PdfDictionary)requiredFontDictionary);
                    fontAndSize[0] = dicFont;
                }
                fontAndSize[1] = this.fontSize >= 0.0f ? Float.valueOf(this.fontSize) : dab[1];
                if (this.color == null) {
                    this.color = (Color)dab[2];
                }
            } else {
                fontAndSize[0] = this.font != null ? this.font : PdfFontFactory.createFont();
                fontAndSize[1] = this.fontSize >= 0.0f ? Float.valueOf(this.fontSize) : Float.valueOf(12.0f);
            }
        } else {
            fontAndSize[0] = this.font != null ? this.font : PdfFontFactory.createFont();
            fontAndSize[1] = this.fontSize >= 0.0f ? Float.valueOf(this.fontSize) : Float.valueOf(12.0f);
        }
        return fontAndSize;
    }

    protected static Object[] splitDAelements(String da) {
        PdfTokenizer tk = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(PdfEncodings.convertToBytes((String)da, null))));
        ArrayList<String> stack = new ArrayList<String>();
        Object[] ret = new Object[3];
        try {
            while (tk.nextToken()) {
                if (tk.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
                if (tk.getTokenType() == PdfTokenizer.TokenType.Other) {
                    String operator = tk.getStringValue();
                    if (operator.equals("Tf")) {
                        if (stack.size() >= 2) {
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Float((String)stack.get(stack.size() - 1));
                        }
                    } else if (operator.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) != 0.0f) {
                            ret[2] = new DeviceGray(gray);
                        }
                    } else if (operator.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            float green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            float blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceRgb(red, green, blue);
                        }
                    } else if (operator.equals("k") && stack.size() >= 4) {
                        float cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                        float magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                        float yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                        float black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                        ret[2] = new DeviceCmyk(cyan, magenta, yellow, black);
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    protected void drawTextAppearance(Rectangle rect, PdfFont font, float fontSize, String value, PdfFormXObject appearance) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, this.color, resources));
        float height = rect.getHeight();
        float width = rect.getWidth();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        this.drawBorder(canvas, xObject, width, height);
        if (this.isPassword()) {
            value = this.obfuscatePassword(value);
        }
        canvas.beginVariableText().saveState().newPath();
        float x = 2.0f;
        Integer justification = this.getJustification();
        if (justification == null) {
            justification = 0;
        }
        TextAlignment textAlignment = TextAlignment.LEFT;
        if (justification == 2) {
            textAlignment = TextAlignment.RIGHT;
            x = rect.getWidth();
        } else if (justification == 1) {
            textAlignment = TextAlignment.CENTER;
            x = rect.getWidth() / 2.0f;
        }
        Canvas modelCanvas = new Canvas(canvas, this.getDocument(), new Rectangle(0.0f, -height, 0.0f, 2.0f * height));
        modelCanvas.setProperty(82, (Object)true);
        if (this.getFieldFlag(PdfTextFormField.FF_COMB)) {
            PdfNumber maxLenEntry = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.MaxLen);
            if (maxLenEntry == null) {
                throw new PdfException("No /MaxLen has been set even though the Comb flag has been set.");
            }
            int maxLen = maxLenEntry.intValue();
            float widthPerCharacter = width / (float)maxLen;
            Paragraph paragraph = ((Paragraph)((Paragraph)new Paragraph().setFont(font)).setFontSize(fontSize)).setMultipliedLeading(1.0f);
            if (this.color != null) {
                paragraph.setFontColor(this.color);
            }
            int numberOfCharacters = maxLen >= value.length() ? value.length() : maxLen;
            for (int i = 0; i < numberOfCharacters; ++i) {
                String characterToPlace = value.substring(i, i + 1);
                float characterWidth = font.getWidth(characterToPlace, fontSize);
                float xOffset = characterWidth == 0.0f ? characterWidth : (widthPerCharacter - characterWidth) / 2.0f;
                paragraph.setPaddings(0.0f, xOffset, 0.0f, xOffset);
                paragraph.add(characterToPlace);
                modelCanvas.showTextAligned(paragraph, widthPerCharacter * (float)i, 0.0f, textAlignment);
                paragraph.getChildren().remove(0);
            }
        } else {
            Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)new Paragraph(value).setFont(font)).setFontSize(fontSize)).setMultipliedLeading(1.0f).setPaddings(0.0f, 2.0f, 0.0f, 2.0f);
            if (this.color != null) {
                paragraph.setFontColor(this.color);
            }
            modelCanvas.showTextAligned(paragraph, x, rect.getHeight() / 2.0f, textAlignment, VerticalAlignment.MIDDLE);
        }
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    protected void drawMultiLineTextAppearance(Rectangle rect, PdfFont font, float fontSize, String value, PdfFormXObject appearance) {
        Boolean isFull;
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, this.color, resources));
        float width = rect.getWidth();
        float height = rect.getHeight();
        List strings = font.splitString(value, fontSize, width - 6.0f);
        this.drawBorder(canvas, appearance, width, height);
        canvas.beginVariableText().saveState().rectangle(3.0, 3.0, (double)(width - 6.0f), (double)(height - 6.0f)).clip().newPath();
        Canvas modelCanvas = new Canvas(canvas, this.getDocument(), new Rectangle(3.0f, 0.0f, Math.max(0.0f, width - 6.0f), Math.max(0.0f, height - 2.0f)));
        modelCanvas.setProperty(82, (Object)true);
        for (int index = 0; index < strings.size() && !Boolean.TRUE.equals(isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25)); ++index) {
            PdfArray indices;
            Paragraph paragraph = ((Paragraph)((Paragraph)((Paragraph)new Paragraph((String)strings.get(index)).setFont(font)).setFontSize(fontSize)).setMargins(0.0f, 0.0f, 0.0f, 0.0f)).setMultipliedLeading(1.0f);
            paragraph.setProperty(26, (Object)true);
            if (this.color != null) {
                paragraph.setFontColor(this.color);
            }
            if ((indices = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.I)) != null && indices.size() > 0) {
                for (PdfObject ind : indices) {
                    if (!ind.isNumber() || ((PdfNumber)ind).getValue() != (double)index) continue;
                    paragraph.setBackgroundColor((Color)new DeviceRgb(10, 36, 106));
                    paragraph.setFontColor(ColorConstants.LIGHT_GRAY);
                }
            }
            modelCanvas.add((IBlockElement)paragraph);
        }
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    protected void drawBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        if (this.borderColor == null) {
            this.borderColor = ColorConstants.BLACK;
        }
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).rectangle((double)(borderWidth / 2.0f), (double)(borderWidth / 2.0f), (double)(width - borderWidth), (double)(height - borderWidth)).fill();
        }
        if (borderWidth > 0.0f) {
            PdfArray dashArray;
            PdfName borderType;
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth);
            if (bs != null && (borderType = bs.getAsName(PdfName.S)) != null && borderType.equals((Object)PdfName.D) && (dashArray = bs.getAsArray(PdfName.D)) != null) {
                int unitsOn = dashArray.getAsNumber(0) != null ? dashArray.getAsNumber(0).intValue() : 0;
                int unitsOff = dashArray.getAsNumber(1) != null ? dashArray.getAsNumber(1).intValue() : 0;
                canvas.setLineDash((float)unitsOn, (float)unitsOff, 0.0f);
            }
            canvas.rectangle(0.0, 0.0, (double)width, (double)height).stroke();
        }
        this.applyRotation(xObject, height, width);
        canvas.restoreState();
    }

    protected void drawRadioBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        float cx = width / 2.0f;
        float cy = height / 2.0f;
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        float r = (Math.min(width, height) - borderWidth) / 2.0f;
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).circle((double)cx, (double)cy, (double)(r + borderWidth / 2.0f)).fill();
        }
        if (borderWidth > 0.0f && this.borderColor != null) {
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth).circle((double)cx, (double)cy, (double)r).stroke();
        }
        this.applyRotation(xObject, height, width);
        canvas.restoreState();
    }

    protected void drawRadioAppearance(float width, float height, String value) {
        PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawRadioBorder(canvasOn, xObjectOn, width, height);
        this.drawRadioField(canvasOn, width, height, true);
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        this.drawRadioBorder(canvasOff, xObjectOff, width, height);
        if (this.pdfAConformanceLevel != null && (this.pdfAConformanceLevel.getPart().equals("2") || this.pdfAConformanceLevel.getPart().equals("3"))) {
            xObjectOn.getResources();
            xObjectOff.getResources();
        }
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        widget.setNormalAppearance(new PdfDictionary());
        widget.getNormalAppearanceObject().put(new PdfName(value), xObjectOn.getPdfObject());
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        widget.getNormalAppearanceObject().put(new PdfName("Off"), xObjectOff.getPdfObject());
    }

    protected void drawPdfA1RadioAppearance(float width, float height, String value) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.drawBorder(canvas, xObject, width, height);
        this.drawRadioField(canvas, rect.getWidth(), rect.getHeight(), !value.equals("Off"));
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        widget.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    protected void drawRadioField(PdfCanvas canvas, float width, float height, boolean on) {
        canvas.saveState();
        if (on) {
            canvas.resetFillColorRgb().circle((double)(width / 2.0f), (double)(height / 2.0f), (double)(Math.min(width, height) / 4.0f)).fill();
        }
        canvas.restoreState();
    }

    protected void drawCheckAppearance(float width, float height, String value) {
        PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawCheckBox(canvasOn, width, height, 12.0f, true);
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        this.drawBorder(canvasOff, xObjectOff, width, height);
        this.drawCheckBox(canvasOff, width, height, 12.0f, false);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        xObjectOn.getResources().addFont(this.getDocument(), this.getFont());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(this.font, this.fontSize <= 0.0f ? 12.0f : this.fontSize, this.color, xObjectOn.getResources()));
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        xObjectOff.getResources().addFont(this.getDocument(), this.getFont());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        ((PdfDictionary)widget.getPdfObject()).put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected void drawPdfA1CheckAppearance(float width, float height, String value, int checkType) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.checkType = checkType;
        this.drawBorder(canvas, xObject, width, height);
        this.drawPdfACheckBox(canvas, width, height, true);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        widget.put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    protected void drawPdfA2CheckAppearance(float width, float height, String value, int checkType) {
        PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.checkType = checkType;
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawPdfACheckBox(canvasOn, width, height, true);
        this.drawBorder(canvasOff, xObjectOff, width, height);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        xObjectOn.getResources();
        xObjectOff.getResources();
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        widget.put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected PdfFormXObject drawPushButtonAppearance(float width, float height, String text, PdfFont font, float fontSize) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        if (this.backgroundColor == null) {
            this.backgroundColor = ColorConstants.LIGHT_GRAY;
        }
        this.drawBorder(canvas, xObject, width, height);
        if (this.img != null) {
            PdfImageXObject imgXObj = new PdfImageXObject(this.img);
            canvas.addXObject((PdfXObject)imgXObj, width - this.borderWidth, 0.0f, 0.0f, height - this.borderWidth, this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addImage(imgXObj);
        } else if (this.form != null) {
            canvas.addXObject((PdfXObject)this.form, (height - this.borderWidth) / this.form.getHeight(), 0.0f, 0.0f, (height - this.borderWidth) / this.form.getHeight(), this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addForm(this.form);
        } else {
            this.drawButton(canvas, 0.0f, 0.0f, width, height, text, font, fontSize);
            this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, this.color, new PdfResources()));
            xObject.getResources().addFont(this.getDocument(), font);
        }
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        return xObject;
    }

    protected void drawButton(PdfCanvas canvas, float x, float y, float width, float height, String text, PdfFont font, float fontSize) {
        if (this.color == null) {
            this.color = ColorConstants.BLACK;
        }
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph(text).setFont(font)).setFontSize(fontSize)).setMargin(0.0f)).setMultipliedLeading(1.0f).setVerticalAlignment(VerticalAlignment.MIDDLE);
        Canvas modelCanvas = new Canvas(canvas, this.getDocument(), new Rectangle(0.0f, -height, width, 2.0f * height));
        modelCanvas.setProperty(82, (Object)true);
        modelCanvas.showTextAligned(paragraph, width / 2.0f, height / 2.0f, TextAlignment.CENTER, VerticalAlignment.MIDDLE);
    }

    protected void drawCheckBox(PdfCanvas canvas, float width, float height, float fontSize, boolean on) {
        if (!on) {
            return;
        }
        if (this.checkType == 3) {
            float offset = this.borderWidth * 2.0f;
            canvas.moveTo((double)((width - height) / 2.0f + offset), (double)(height - offset)).lineTo((double)((width + height) / 2.0f - offset), (double)offset).moveTo((double)((width + height) / 2.0f - offset), (double)(height - offset)).lineTo((double)((width - height) / 2.0f + offset), (double)offset).stroke();
            return;
        }
        PdfFont ufont = this.getFont();
        canvas.beginText().setFontAndSize(ufont, fontSize).resetFillColorRgb().setTextMatrix((width - ufont.getWidth(this.text, fontSize)) / 2.0f, (height - (float)ufont.getAscent(this.text, fontSize)) / 2.0f).showText(this.text).endText();
    }

    protected void drawPdfACheckBox(PdfCanvas canvas, float width, float height, boolean on) {
        if (!on) {
            return;
        }
        String appearanceString = check;
        switch (this.checkType) {
            case 1: {
                appearanceString = check;
                break;
            }
            case 2: {
                appearanceString = circle;
                break;
            }
            case 3: {
                appearanceString = cross;
                break;
            }
            case 4: {
                appearanceString = diamond;
                break;
            }
            case 5: {
                appearanceString = square;
                break;
            }
            case 6: {
                appearanceString = star;
            }
        }
        canvas.saveState();
        canvas.resetFillColorRgb();
        canvas.concatMatrix((double)width, 0.0, 0.0, (double)height, 0.0, 0.0);
        canvas.getContentStream().getOutputStream().writeBytes(appearanceString.getBytes(StandardCharsets.ISO_8859_1));
        canvas.restoreState();
    }

    private PdfName getTypeFromParent(PdfDictionary field) {
        PdfDictionary parent = field.getAsDictionary(PdfName.Parent);
        PdfName formType = field.getAsName(PdfName.FT);
        if (parent != null && (formType = parent.getAsName(PdfName.FT)) == null) {
            formType = this.getTypeFromParent(parent);
        }
        return formType;
    }

    private String obfuscatePassword(String text) {
        char[] pchar = new char[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            pchar[i] = 42;
        }
        return new String(pchar);
    }

    private void applyRotation(PdfFormXObject xObject, float height, float width) {
        switch (this.rotation) {
            case 90: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{0.0f, 1.0f, -1.0f, 0.0f, height, 0.0f}));
                break;
            }
            case 180: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, width, height}));
                break;
            }
            case 270: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width}));
            }
        }
    }

    private static String optionsArrayToString(PdfArray options) {
        StringBuffer stringBuffer = new StringBuffer();
        for (PdfObject obj : options) {
            PdfObject element;
            if (obj.isString()) {
                stringBuffer.append(((PdfString)obj).toUnicodeString()).append('\n');
                continue;
            }
            if (!obj.isArray() || !(element = ((PdfArray)obj).get(1)).isString()) continue;
            stringBuffer.append(((PdfString)element).toUnicodeString()).append('\n');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static double degreeToRadians(double angle) {
        return Math.PI * angle / 180.0;
    }
}

