/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.izone.web.shiro;

import com.google.common.eventbus.Subscribe;
import com.iteaj.izone.api.LoggerEntity;
import com.iteaj.izone.api.LoggerService;
import com.iteaj.izone.spi.event.Event;
import com.iteaj.izone.spi.event.Listener;
import com.iteaj.izone.web.shiro.ShiroAuthorEvent;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;

public class ShiroAuthorLogListener
implements Listener<ShiroAuthorEvent> {
    private LoggerService loggerService;

    public ShiroAuthorLogListener(LoggerService loggerService) {
        this.loggerService = loggerService;
    }

    public ShiroAuthorLogListener setLoggerService(LoggerService loggerService) {
        this.loggerService = loggerService;
        return this;
    }

    @Override
    public boolean accepts(Event event) {
        return event instanceof ShiroAuthorEvent;
    }

    @Override
    @Subscribe
    public void onEvent(ShiroAuthorEvent event) {
        String[] perms = this.getPerms(event.getMethod());
        String errMsg = StringUtils.hasText((String)event.getErrMsg()) ? event.getErrMsg() : event.getType().desc;
        String requestURI = null;
        if (event.getRequest() != null) {
            requestURI = event.getRequest().getRequestURI();
        }
        LoggerEntity loggerEntity = new LoggerEntity(requestURI, event.getArgs(), event.getSource(), event.getType()).setShortName(this.getShortName(event.getMethod())).setPerms(perms).setId("Shiro").setErrMsg(errMsg).setOperaTime(event.getOperaTimeMillis());
        this.loggerService.record(loggerEntity);
    }

    private String[] getPerms(Method method) {
        RequiresPermissions permissions;
        if (method != null && (permissions = method.getDeclaredAnnotation(RequiresPermissions.class)) != null) {
            return permissions.value();
        }
        return new String[0];
    }

    private String getShortName(Method method) {
        if (null == method) {
            return "";
        }
        Class<?> declaringClass = method.getDeclaringClass();
        String methodArgs = Stream.of(method.getParameterTypes()).map(obj -> obj.getSimpleName()).reduce((i, j) -> i + ',' + j).orElse("");
        return String.format("%s.%s(%s)", declaringClass.getSimpleName(), method.getName(), methodArgs);
    }
}

