/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.taos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TruncateLinkedList<E> {
    private int size;
    private Node<E> first;
    private Node<E> last;

    public synchronized void addLast(E e) {
        Node<E> l = this.last;
        Node<E> newNode = new Node<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            ((Node)l).next = (Node)newNode;
        }
        ++this.size;
    }

    public synchronized void addAll(Collection<E> list) {
        list.forEach(item -> this.addLast(item));
    }

    public List<E> subList(int formIndex, int toIndex) {
        if (formIndex >= this.size || this.size < toIndex) {
            throw new IndexOutOfBoundsException(formIndex + ">" + this.size);
        }
        ArrayList<Object> list = new ArrayList<Object>(toIndex - formIndex);
        Node current = this.first;
        for (int index = 0; index < toIndex; ++index) {
            if (index >= formIndex) {
                list.add(current.item);
            }
            current = current.next;
        }
        return list;
    }

    public synchronized void truncate(int formIndex) {
        if (formIndex == this.size) {
            this.last = null;
            this.first = null;
            this.size = 0;
            return;
        }
        if (formIndex > this.size) {
            throw new IndexOutOfBoundsException(formIndex + ">" + this.size);
        }
        Node current = this.first;
        for (int index = 0; index <= formIndex; ++index) {
            if (index == formIndex) {
                current.prev = null;
                this.first = current;
                this.size -= formIndex;
                return;
            }
            current = current.next;
        }
    }

    public int size() {
        return this.size;
    }

    public Node<E> getFirst() {
        return this.first;
    }

    public Node<E> getLast() {
        return this.last;
    }

    public String toString() {
        return "size=" + this.size;
    }

    class Node<E> {
        private E item;
        private Node<E> prev;
        private Node<E> next;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

