/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.taos;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.iteaj.iot.taos.STable;
import com.iteaj.iot.taos.TaosException;
import com.iteaj.iot.tools.annotation.IotField;
import com.iteaj.iot.tools.annotation.IotFieldMeta;
import com.iteaj.iot.tools.annotation.IotTableId;
import com.iteaj.iot.tools.annotation.IotTableIdMeta;
import com.iteaj.iot.tools.annotation.IotTag;
import com.iteaj.iot.tools.annotation.IotTagMeta;
import com.iteaj.iot.tools.db.FieldMeta;
import com.iteaj.iot.tools.db.ParamValue;
import com.iteaj.iot.tools.db.sql.SqlAnnotationMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TaosSqlMeta
extends SqlAnnotationMeta {
    boolean using;
    private STable sTable;
    private String dataTableName;
    private String sTableName;
    private String insertSql;
    private String paramSql;
    private String tagInsertSql;
    private String tagParamSql;
    private List<IotTagMeta> tags = new ArrayList<IotTagMeta>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>(16);
    private static ParamValue NULL = new ParamValue(null, null);

    protected TaosSqlMeta(Class<?> entityClass) {
        super(entityClass);
    }

    public TaosSqlMeta(String stableName, String dataTableName, List<FieldMeta> fieldMetas) {
        this(stableName, dataTableName, fieldMetas, true);
    }

    public TaosSqlMeta(String stableName, String dataTableName, List<FieldMeta> fieldMetas, boolean using) {
        this(stableName, dataTableName, fieldMetas, null);
        this.using = using;
    }

    public TaosSqlMeta(String stableName, String dataTableName, List<FieldMeta> fieldMetas, List<IotTagMeta> tagMetas) {
        super(stableName, fieldMetas);
        this.using = true;
        this.tags = tagMetas;
        this.sTableName = stableName;
        this.dataTableName = dataTableName;
        this.handleSqlStatement();
    }

    protected void resolveEntityTypeToMetas(Class<?> entityClass) {
    }

    protected void resolveInsertSql() {
    }

    protected TaosSqlMeta build() {
        Field[] declaredFields;
        this.sTable = this.getEntityClass().getAnnotation(STable.class);
        if (this.sTable == null) {
            throw new TaosException("\u5b9e\u4f53\u7c7b[" + this.getEntityClass().getSimpleName() + "]\u672a\u627e\u5230\u6ce8\u89e3[STable]");
        }
        this.using = this.sTable.using();
        this.sTableName = this.sTable.value();
        this.dataTableName = this.sTable.table();
        if (StrUtil.isBlank((CharSequence)this.dataTableName)) {
            throw new TaosException("\u6570\u636e\u8868\u540d\u5fc5\u586b[STable#table()]");
        }
        for (Field item : declaredFields = this.getEntityClass().getDeclaredFields()) {
            IotTag iotTag;
            IotField field;
            if (!item.isAccessible()) {
                item.setAccessible(true);
            }
            this.fieldMap.put(item.getName(), item);
            IotTableId fieldId = item.getAnnotation(IotTableId.class);
            if (fieldId != null) {
                if (!Date.class.isAssignableFrom(item.getType()) && Long.class != item.getType() && Long.TYPE != item.getType()) {
                    throw new TaosException("Id\u6ce8\u89e3\u5b57\u6bb5[" + item.getName() + "]\u5fc5\u987b\u662f\u7c7b\u578b[Date or Long]");
                }
                this.getFieldMetas().add(0, new IotTableIdMeta(fieldId, item));
            }
            if ((field = item.getAnnotation(IotField.class)) != null) {
                this.getFieldMetas().add(new IotFieldMeta(field, item));
            }
            if ((iotTag = item.getAnnotation(IotTag.class)) == null) continue;
            this.tags.add(new IotTagMeta(iotTag, item));
        }
        return this.handleSqlStatement();
    }

    protected TaosSqlMeta handleSqlStatement() {
        this.paramSql = "(" + this.getFieldMetas().stream().map(item -> "?").collect(Collectors.joining(",")) + ")";
        this.insertSql = "(" + this.getFieldMetas().stream().map(item -> item.getName()).collect(Collectors.joining(",")) + ")";
        if (this.isUsing()) {
            if (StrUtil.isBlank((CharSequence)this.sTableName)) {
                throw new TaosException("\u4f7f\u7528\u8d85\u7ea7\u8868\u81ea\u52a8\u521b\u5efa\u6570\u636e\u8868\u65f6\u8d85\u7ea7\u8868\u7684\u8868\u540d\u5fc5\u586b");
            }
            if (CollectionUtil.isNotEmpty(this.tags)) {
                this.tagInsertSql = "USING " + this.sTable.value() + " (" + this.tags.stream().map(item -> item.getName()).collect(Collectors.joining(",")) + ")";
                this.tagParamSql = "(" + this.tags.stream().map(item -> "?").collect(Collectors.joining(",")) + ")";
            }
        }
        return this;
    }

    public String getTableName() {
        return this.sTableName;
    }

    public List<ParamValue> getTagParams(Object value) {
        ArrayList<ParamValue> params = new ArrayList<ParamValue>();
        this.tags.forEach(item -> {
            Object fieldValue = ReflectUtil.getFieldValue((Object)value, (Field)item.getField());
            params.add(new ParamValue((FieldMeta)item, fieldValue));
        });
        return params;
    }

    public String getFieldValue(String fieldName, Object entity) {
        Object fieldValue;
        Field field = this.fieldMap.get(fieldName);
        if (field != null && (fieldValue = ReflectUtil.getFieldValue((Object)entity, (Field)field)) != null) {
            return fieldValue.toString();
        }
        return null;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public String getParamSql() {
        return this.paramSql;
    }

    public STable getsTable() {
        return this.sTable;
    }

    public List<IotTagMeta> getTags() {
        return this.tags;
    }

    public String getTagInsertSql() {
        return this.tagInsertSql;
    }

    public void setTagInsertSql(String tagInsertSql) {
        this.tagInsertSql = tagInsertSql;
    }

    public String getTagParamSql() {
        return this.tagParamSql;
    }

    public void setTagParamSql(String tagParamSql) {
        this.tagParamSql = tagParamSql;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public boolean isUsing() {
        return this.using;
    }
}

