/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.taos;

import cn.hutool.core.collection.CollectionUtil;
import com.iteaj.iot.taos.EntitySql;
import com.iteaj.iot.taos.SqlExecContext;
import com.iteaj.iot.taos.TaosException;
import com.iteaj.iot.taos.TaosSqlMeta;
import com.iteaj.iot.tools.db.ParamValue;
import com.iteaj.iot.tools.db.sql.SqlStatementUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlContext {
    private TaosSqlMeta meta;
    private static final String Insert = "insert into ";
    private static final Pattern regex = Pattern.compile("\\$\\{([^}]*)\\}");
    private static Logger logger = LoggerFactory.getLogger(SqlContext.class);

    public SqlContext(TaosSqlMeta meta) {
        this.meta = meta;
    }

    public SqlExecContext getExecContext(Collection<EntitySql> execEntitySqls) {
        if (CollectionUtil.isEmpty(execEntitySqls)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(Insert);
        TaosSqlMeta meta = this.getMeta();
        HashMap<String, List> stringListMap = new HashMap<String, List>();
        ArrayList parameterValues = new ArrayList();
        execEntitySqls.forEach(item -> {
            ArrayList<EntitySql> entitySqls = (ArrayList<EntitySql>)stringListMap.get(item.getTableName());
            if (entitySqls == null) {
                entitySqls = new ArrayList<EntitySql>();
                stringListMap.put(item.getTableName(), entitySqls);
            }
            entitySqls.add((EntitySql)item);
        });
        stringListMap.forEach((tableName, entitySqls) -> {
            sb.append((String)tableName);
            if (meta.getTagInsertSql() != null) {
                EntitySql entitySql = (EntitySql)entitySqls.get(0);
                sb.append(" ").append(meta.getTagInsertSql()).append(" tags ").append(meta.getTagParamSql());
                List<ParamValue> tagParams = meta.getTagParams(entitySql.getEntity());
                parameterValues.addAll(tagParams);
            }
            sb.append(" ").append(meta.getInsertSql()).append(" values ");
            entitySqls.forEach(item -> {
                sb.append(meta.getParamSql()).append(" ");
                parameterValues.addAll(item.getValues());
            });
        });
        return new SqlExecContext(sb, (ParamValue[])parameterValues.stream().toArray(ParamValue[]::new));
    }

    public SqlExecContext getExecContext(Object entity) {
        String tableName = this.getTableName(entity);
        StringBuilder sb = new StringBuilder(Insert).append(tableName).append(" ");
        ArrayList<ParamValue> parameterValues = new ArrayList<ParamValue>();
        if (this.getMeta().isUsing() && CollectionUtil.isNotEmpty(this.getMeta().getTags())) {
            sb.append(this.meta.getTagInsertSql()).append(" tags ").append(this.meta.getTagParamSql());
            parameterValues.addAll(this.meta.getTagParams(entity));
        }
        sb.append(" ").append(this.meta.getInsertSql()).append(" values ").append(this.meta.getParamSql());
        parameterValues.addAll(this.meta.getParams(entity));
        return new SqlExecContext(sb, (ParamValue[])parameterValues.stream().toArray(ParamValue[]::new));
    }

    public String getTableName(Object entity) {
        String tableName = this.getMeta().getDataTableName();
        try {
            Matcher matcher = regex.matcher(tableName);
            while (matcher.find()) {
                String fieldName = matcher.group(1);
                String fieldValue = null;
                if (entity instanceof Map) {
                    Object o = ((Map)entity).get(fieldName);
                    if (o != null) {
                        fieldValue = o.toString();
                    }
                } else {
                    fieldValue = this.meta.getFieldValue(fieldName, entity);
                }
                tableName = tableName.replace("${" + fieldName + "}", fieldValue);
            }
            return tableName;
        }
        catch (Exception e) {
            throw new TaosException("\u89e3\u6790\u6570\u636e\u8868\u540d\u5931\u8d25[" + tableName + "], \u89e3\u6790\u4e0a\u4e0b\u6587\u5bf9\u8c61[" + entity + "]", e);
        }
    }

    public int update(Object entity, DataSource dataSource) {
        return this.doUpdate(this.getExecContext(entity), dataSource, 1);
    }

    public int update(List<Object> entities, DataSource dataSource) {
        ArrayList<EntitySql> entitySqls = new ArrayList<EntitySql>(entities.size());
        entities.forEach(entity -> {
            String value = this.getTableName(entity);
            List params = this.getMeta().getParams(entity);
            entitySqls.add(new EntitySql(value, entity, params));
        });
        return this.doUpdate(this.getExecContext(entitySqls), dataSource, entities.size());
    }

    protected int doUpdate(SqlExecContext context, DataSource dataSource, int size) throws TaosException {
        int i;
        long start = System.currentTimeMillis();
        try {
            Object[] objects = Arrays.stream(context.getValues()).map(item -> item.getFieldValue()).toArray();
            i = SqlStatementUtil.execute((Connection)dataSource.getConnection(), (String)context.getSql().toString(), (Object[])objects);
            this.writeLogger(context, null, start, size);
        }
        catch (SQLException e) {
            this.writeLogger(context, e, start, size);
            throw new TaosException(e);
        }
        return i;
    }

    private void writeLogger(SqlExecContext execContext, Throwable cause, long start, int size) {
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (ParamValue value : execContext.getValues()) {
                sb.append(value.getFieldValue()).append(", ");
            }
            logger.trace("TAOS\u9002\u914d \u6570\u636e\u5165\u5e93({}ms) - \u6761\u6570\uff1a{}\r\n\t    Sql\uff1a{} \r\n\t params\uff1a{}", new Object[]{System.currentTimeMillis() - start, size, execContext.getSql().toString(), sb.substring(0, sb.length() - 2), cause});
        }
    }

    public TaosSqlMeta getMeta() {
        return this.meta;
    }

    public void setMeta(TaosSqlMeta meta) {
        this.meta = meta;
    }
}

