/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.taos;

import cn.hutool.core.collection.CollectionUtil;
import com.iteaj.iot.taos.STable;
import com.iteaj.iot.taos.SqlContext;
import com.iteaj.iot.taos.TaosException;
import com.iteaj.iot.taos.TaosHandle;
import com.iteaj.iot.taos.TaosSqlManager;
import com.iteaj.iot.taos.TaosSqlMeta;
import com.iteaj.iot.tools.db.DBMeta;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaosSqlManager
implements TaosSqlManager<TaosHandle> {
    private DataSource dataSource;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Class<?>, SqlContext> sqlContextMap = new ConcurrentHashMap(16);
    private Map<String, SqlContext> tableNameAndSqlContextMap = new ConcurrentHashMap<String, SqlContext>(16);

    public DefaultTaosSqlManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaosSqlMeta getDBMeta(Class<?> entityClass) {
        SqlContext sqlContext = this.sqlContextMap.get(entityClass);
        if (sqlContext == null) {
            DefaultTaosSqlManager defaultTaosSqlManager = this;
            synchronized (defaultTaosSqlManager) {
                TaosSqlMeta taosSqlMeta = new TaosSqlMeta(entityClass).build();
                if (entityClass == null) {
                    throw new TaosException("[" + TaosHandle.class.getSimpleName() + "]\u5bf9\u8c61\u7684\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u5fc5\u987b\u4f7f\u7528" + STable.class.getSimpleName() + "\u6ce8\u89e3");
                }
                sqlContext = new SqlContext(taosSqlMeta);
                this.sqlContextMap.put(entityClass, sqlContext);
            }
        }
        return sqlContext.getMeta();
    }

    @Override
    public TaosSqlMeta getDBMeta(String tableName) {
        return this.tableNameAndSqlContextMap.get(tableName).getMeta();
    }

    public DBMeta remove(String tableName) {
        return this.tableNameAndSqlContextMap.remove(tableName).getMeta();
    }

    public TaosSqlMeta register(DBMeta meta) {
        if (meta instanceof TaosSqlMeta) {
            SqlContext sqlContext = new SqlContext((TaosSqlMeta)meta);
            this.tableNameAndSqlContextMap.put(meta.getTableName(), sqlContext);
            return sqlContext.getMeta();
        }
        throw new TaosException("\u53ea\u652f\u6301[" + TaosSqlMeta.class.getSimpleName() + "]\u7c7b\u578b\u5bf9\u8c61");
    }

    public TaosSqlMeta registerIfAbsent(DBMeta meta) {
        if (!this.tableNameAndSqlContextMap.containsKey(meta.getTableName())) {
            return this.register(meta);
        }
        return null;
    }

    public SqlContext getSqlContext(Class entityClass) {
        SqlContext sqlContext = this.sqlContextMap.get(entityClass);
        if (sqlContext == null) {
            this.getDBMeta(entityClass);
        }
        return this.sqlContextMap.get(entityClass);
    }

    public SqlContext getSqlContext(String tableName) {
        SqlContext sqlContext = this.tableNameAndSqlContextMap.get(tableName);
        if (sqlContext == null) {
            throw new TaosException("\u8868[" + tableName + "]\u5bf9\u5e94\u7684\u5143\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        return sqlContext;
    }

    @Override
    public int batchInsert(Class entityClazz, List<Object> entities) {
        SqlContext sqlContext = this.getSqlContext(entityClazz);
        return sqlContext.update(entities, this.dataSource);
    }

    @Override
    public int insert(String tableName, Object entity) {
        SqlContext sqlContext = this.getSqlContext(tableName);
        return sqlContext.update(entity, this.dataSource);
    }

    public int insert(String tableName, Map<String, Object> value) {
        SqlContext sqlContext = this.getSqlContext(tableName);
        return sqlContext.update(value, this.dataSource);
    }

    @Override
    public int insert(Class entityClazz, Object entity) {
        SqlContext sqlContext = this.getSqlContext(entityClazz);
        return sqlContext.update(entity, this.dataSource);
    }

    @Override
    public int batchInsert(String tableName, List<Object> entities) {
        SqlContext sqlContext = this.getSqlContext(tableName);
        return sqlContext.update(entities, this.dataSource);
    }

    @Override
    public int batchInsert(Class entityClazz, List<Object> entities, int size) {
        if (CollectionUtil.isEmpty(entities)) {
            return 0;
        }
        if (entities.size() < size) {
            return this.batchInsert(entityClazz, entities);
        }
        int updateIndex = 0;
        int index = entities.size() / size;
        int remain = entities.size() % size;
        index = remain == 0 ? index : index + 1;
        for (int i = 0; i < index; ++i) {
            List<Object> objects = i == index - 1 ? entities.subList(i * size, entities.size()) : entities.subList(i * size, i * size + size);
            updateIndex += this.batchInsert(entityClazz, objects);
        }
        return updateIndex;
    }

    @Override
    public void execute(Object value, TaosHandle handle) {
        SqlContext sqlContext = this.getSqlContext(value.getClass());
        sqlContext.update(value, handle.taosDataSource(value));
    }
}

