/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.websocket.impl;

import com.iteaj.iot.server.ServerProtocolHandle;
import com.iteaj.iot.server.websocket.WebSocketServerListener;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerMessage;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerProtocol;
import com.iteaj.iot.websocket.WebSocketException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketServerProtocolHandle
implements ServerProtocolHandle<DefaultWebSocketServerProtocol> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, WebSocketServerListener> listeners;

    public DefaultWebSocketServerProtocolHandle(Map<String, WebSocketServerListener> listeners) {
        this.listeners = listeners;
    }

    public Object handle(DefaultWebSocketServerProtocol protocol) {
        block6: {
            DefaultWebSocketServerMessage requestMessage;
            block5: {
                requestMessage = (DefaultWebSocketServerMessage)protocol.requestMessage();
                WebSocketServerListener listener = this.listeners.get(requestMessage.uri());
                if (listener == null) break block5;
                switch (requestMessage.frameType()) {
                    case Text: {
                        listener.onText(protocol);
                        break block6;
                    }
                    case Binary: {
                        listener.onBinary(protocol);
                        break block6;
                    }
                    case Close: {
                        listener.onClose(protocol);
                        break block6;
                    }
                    default: {
                        throw new WebSocketException("\u4e0d\u652f\u6301\u7684\u4e8b\u4ef6[" + requestMessage.frameType() + "]");
                    }
                }
            }
            this.logger.warn("WebSocket \u672a\u627e\u5230\u76d1\u542c\u5668(\u8bf7\u786e\u8ba4uri\u662f\u5426\u5b8c\u5168\u5339\u914d) - uri\uff1a{} - cause\uff1a\u5c06\u5bfc\u81f4\u65e0\u6cd5\u5904\u7406\u6b64uri\u7684\u8bf7\u6c42", (Object)requestMessage.uri());
        }
        return null;
    }
}

