/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.websocket.impl;

import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.message.DefaultMessageBody;
import com.iteaj.iot.message.DefaultMessageHead;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import com.iteaj.iot.server.websocket.WebSocketChannelMatcher;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerComponent;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerMessage;
import com.iteaj.iot.utils.ByteUtil;
import com.iteaj.iot.websocket.WebSocketCloseBody;
import com.iteaj.iot.websocket.WebSocketCloseHead;
import com.iteaj.iot.websocket.WebSocketException;
import com.iteaj.iot.websocket.WebSocketFrameType;
import com.iteaj.iot.websocket.WebSocketProtocolType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class DefaultWebSocketServerProtocol
extends ClientInitiativeProtocol<DefaultWebSocketServerMessage> {
    private DefaultWebSocketServerMessage response;

    public DefaultWebSocketServerProtocol(DefaultWebSocketServerMessage requestMessage) {
        super(requestMessage);
    }

    public String readText() {
        byte[] message = ((DefaultWebSocketServerMessage)this.requestMessage()).getMessage();
        return new String(message, StandardCharsets.UTF_8);
    }

    public byte[] readBinary() {
        return ((DefaultWebSocketServerMessage)this.requestMessage()).getMessage();
    }

    public void response(String text) {
        Message.MessageHead head = ((DefaultWebSocketServerMessage)this.requestMessage()).getHead();
        DefaultMessageHead messageHead = new DefaultMessageHead(head.getEquipCode(), head.getMessageId(), (ProtocolType)head.getType());
        this.response = new DefaultWebSocketServerMessage((Message.MessageHead)messageHead, (Message.MessageBody)new DefaultMessageBody(text.getBytes(StandardCharsets.UTF_8)), WebSocketFrameType.Text);
    }

    public void response(byte[] binaryData) {
        Message.MessageHead head = ((DefaultWebSocketServerMessage)this.requestMessage()).getHead();
        DefaultMessageHead messageHead = new DefaultMessageHead(head.getEquipCode(), head.getMessageId(), (ProtocolType)head.getType());
        this.response = new DefaultWebSocketServerMessage((Message.MessageHead)messageHead, (Message.MessageBody)new DefaultMessageBody(binaryData), WebSocketFrameType.Binary);
    }

    public void response(DefaultWebSocketServerMessage response) {
        this.response = response;
    }

    public void response(int rsv, byte[] message) {
        Message.MessageHead head = ((DefaultWebSocketServerMessage)this.requestMessage()).getHead();
        WebSocketCloseHead closeHead = new WebSocketCloseHead(head.getEquipCode());
        this.response = new DefaultWebSocketServerMessage((Message.MessageHead)closeHead, (Message.MessageBody)new WebSocketCloseBody(rsv, message));
    }

    public void response(WebSocketCloseStatus status, String reasonText) {
        Message.MessageHead head = ((DefaultWebSocketServerMessage)this.requestMessage()).getHead();
        WebSocketCloseHead closeHead = new WebSocketCloseHead(head.getEquipCode());
        this.response = new DefaultWebSocketServerMessage((Message.MessageHead)closeHead, (Message.MessageBody)new WebSocketCloseBody(status, reasonText)).setFrameType(WebSocketFrameType.Close);
    }

    public static Optional<ChannelFuture> close(String equipCode, WebSocketCloseStatus status, String reasonText) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            WebSocketCloseHead closeHead = new WebSocketCloseHead(equipCode);
            return serverComponent.writeAndFlush(equipCode, (Object)new DefaultWebSocketServerMessage((Message.MessageHead)closeHead, (Message.MessageBody)new WebSocketCloseBody(status, reasonText), WebSocketFrameType.Close), new Object[0]);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> closeGroup(String uri, WebSocketCloseStatus status, String reasonText) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            WebSocketCloseHead closeHead = new WebSocketCloseHead(null);
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)new DefaultWebSocketServerMessage((Message.MessageHead)closeHead, (Message.MessageBody)new WebSocketCloseBody(status, reasonText), WebSocketFrameType.Close));
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> closeGroup(String uri, WebSocketCloseStatus status, String reasonText, WebSocketChannelMatcher matcher) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            WebSocketCloseHead closeHead = new WebSocketCloseHead(null);
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)new DefaultWebSocketServerMessage((Message.MessageHead)closeHead, (Message.MessageBody)new WebSocketCloseBody(status, reasonText), WebSocketFrameType.Close), matcher);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelFuture> write(String equipCode, String msg) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            return serverComponent.writeAndFlush(equipCode, (Object)new DefaultWebSocketServerMessage(msg.getBytes(StandardCharsets.UTF_8)).setFrameType(WebSocketFrameType.Text), new Object[0]);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelFuture> write(String equipCode, byte[] msg) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            return serverComponent.writeAndFlush(equipCode, (Object)new DefaultWebSocketServerMessage(msg).setFrameType(WebSocketFrameType.Binary), new Object[0]);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> writeGroup(String uri, String text) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            DefaultWebSocketServerMessage serverMessage = new DefaultWebSocketServerMessage(text.getBytes(StandardCharsets.UTF_8)).setFrameType(WebSocketFrameType.Text);
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)serverMessage);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> writeGroup(String uri, String text, WebSocketChannelMatcher matcher) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            DefaultWebSocketServerMessage serverMessage = new DefaultWebSocketServerMessage(text.getBytes(StandardCharsets.UTF_8)).setFrameType(WebSocketFrameType.Text);
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)serverMessage, matcher);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> writeGroup(String uri, byte[] msg, WebSocketChannelMatcher matcher) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            DefaultWebSocketServerMessage message = new DefaultWebSocketServerMessage(msg).setFrameType(WebSocketFrameType.Binary);
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)message, matcher);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> writeGroup(String uri, DefaultWebSocketServerMessage msg) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)msg);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    public static Optional<ChannelGroupFuture> writeGroup(String uri, DefaultWebSocketServerMessage msg, WebSocketChannelMatcher matcher) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultWebSocketServerMessage.class);
        if (serverComponent instanceof DefaultWebSocketServerComponent) {
            return ((DefaultWebSocketServerComponent)serverComponent).writeGroup(uri, (Object)msg, matcher);
        }
        throw new IllegalStateException("\u672a\u542f\u7528websocket\u7ec4\u4ef6[DefaultWebSocketServerComponent]");
    }

    @Override
    protected DefaultWebSocketServerMessage doBuildResponseMessage() {
        DefaultWebSocketServerMessage requestMessage = (DefaultWebSocketServerMessage)this.requestMessage();
        if (requestMessage.frameType() == WebSocketFrameType.Close && this.response != null) {
            throw new WebSocketException("\u5ba2\u6237\u7aef\u4ee5\u4e3b\u52a8\u5173\u95ed\u94fe\u63a5");
        }
        return this.response;
    }

    @Override
    protected void doBuildRequestMessage(DefaultWebSocketServerMessage requestMessage) {
        if (requestMessage.frameType() == WebSocketFrameType.Close) {
            byte[] message = requestMessage.getMessage();
            short statusCode = ByteUtil.bytesToShortOfReverse((byte[])message, (int)0);
            byte[] reason = ByteUtil.subBytes((byte[])message, (int)2);
            requestMessage.setBody((Message.MessageBody)new WebSocketCloseBody(WebSocketCloseStatus.valueOf((int)statusCode), new String(reason, Charset.defaultCharset())));
        }
    }

    @Override
    public ProtocolType protocolType() {
        return WebSocketProtocolType.Default_Server;
    }
}

