/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.websocket;

import com.iteaj.iot.Message;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.websocket.HttpRequestWrapper;
import com.iteaj.iot.websocket.WebSocketFrameType;
import com.iteaj.iot.websocket.WebSocketMessage;
import com.iteaj.iot.websocket.WebSocketServerMessage;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.Optional;

public abstract class WebSocketServerMessageAbstract
extends ServerMessage
implements WebSocketServerMessage {
    private HttpRequestWrapper request;
    private WebSocketFrameType frameType;

    public WebSocketServerMessageAbstract(byte[] message) {
        super(message);
    }

    public WebSocketServerMessageAbstract(Message.MessageHead head) {
        super(head);
    }

    public WebSocketServerMessageAbstract(Message.MessageHead head, Message.MessageBody body) {
        super(head, body);
    }

    public String uri() {
        return this.request().getRawPath();
    }

    public WebSocketVersion version() {
        return this.request().getVersion();
    }

    public Optional<String> getHeader(String key) {
        return Optional.ofNullable(this.request().headers().get(key));
    }

    public Optional<String> getQueryParam(String key) {
        return this.request().getQueryParam(key);
    }

    public WebSocketFrameType frameType() {
        return this.frameType;
    }

    public WebSocketServerMessageAbstract setFrameType(WebSocketFrameType frameType) {
        this.frameType = frameType;
        return this;
    }

    public WebSocketFrameType getFrameType() {
        return this.frameType;
    }

    public HttpRequestWrapper request() {
        return this.request;
    }

    public WebSocketMessage setRequest(HttpRequestWrapper request) {
        this.request = request;
        return this;
    }
}

