/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.websocket;

import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.IotThreadManager;
import com.iteaj.iot.codec.filter.CombinedInterceptor;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.codec.WebSocketServerDecoder;
import com.iteaj.iot.server.component.TcpDecoderServerComponent;
import com.iteaj.iot.server.websocket.WebSocketServerComponent;
import com.iteaj.iot.server.websocket.WebSocketServerMessageAbstract;
import com.iteaj.iot.websocket.WebSocketEncoder;
import com.iteaj.iot.websocket.WebSocketInterceptor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class WebSocketServerComponentAbstract<M extends WebSocketServerMessageAbstract>
extends TcpDecoderServerComponent<M>
implements WebSocketServerComponent<M> {
    private boolean allowExtensions = false;
    private WebSocketEncoder webSocketEncoder = new WebSocketEncoder((FrameworkComponent)this);
    private Map<String, ChannelGroup> uriGroup = new ConcurrentHashMap<String, ChannelGroup>(36);
    private WebSocketServerDecoder decoderAdapter = new WebSocketServerDecoder(this);

    public WebSocketServerComponentAbstract(ConnectProperties connectProperties) {
        this(connectProperties, WebSocketInterceptor.DEFAULT);
    }

    public WebSocketServerComponentAbstract(ConnectProperties connectProperties, WebSocketInterceptor filter) {
        super(connectProperties, (CombinedInterceptor)filter);
    }

    public Optional<ChannelGroup> group(String uri) {
        return Optional.ofNullable(this.uriGroup.get(uri));
    }

    public Optional<ChannelGroupFuture> writeGroup(String uri, Object msg) {
        ChannelGroup channels = this.uriGroup.get(uri);
        if (channels != null) {
            return Optional.of(channels.writeAndFlush(msg));
        }
        return Optional.empty();
    }

    public Optional<ChannelGroupFuture> writeGroup(String uri, Object msg, ChannelMatcher matcher) {
        ChannelGroup channels = this.uriGroup.get(uri);
        if (channels != null) {
            return Optional.of(channels.writeAndFlush(msg, matcher));
        }
        return Optional.empty();
    }

    @Override
    public void doInitChannel(ChannelPipeline p) {
        super.doInitChannel(p);
        p.replace("ServerProtocolEncoder", "ServerProtocolEncoder", (ChannelHandler)this.webSocketEncoder);
        p.addFirst("IOT:HTTP:CODEC", (ChannelHandler)new HttpServerCodec());
    }

    public ChannelInboundHandlerAdapter getMessageDecoder() {
        return this.decoderAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketServerHandshaker createServerHandShaker(ChannelHandlerContext ctx, HttpRequest req) {
        ChannelGroup channels;
        String url = req.uri();
        int i = req.uri().indexOf("?");
        if (i > 0) {
            url = req.uri().substring(0, i);
        }
        if ((channels = this.uriGroup.get(url)) == null) {
            WebSocketServerComponentAbstract webSocketServerComponentAbstract = this;
            synchronized (webSocketServerComponentAbstract) {
                channels = this.uriGroup.get(url);
                if (channels == null) {
                    channels = new DefaultChannelGroup(url, IotThreadManager.instance().getDeviceManageEventExecutor());
                    this.uriGroup.put(url, channels);
                }
            }
        }
        channels.add((Object)ctx.channel());
        ConnectProperties config = this.config();
        String webSocketUrl = config.getSsl() != null ? "wss://" + config.getHost() + ":" + config.getPort() + url : "ws://" + config.getHost() + ":" + config.getPort() + url;
        return this.doCreateServerHandShaker(webSocketUrl, req);
    }

    protected WebSocketServerHandshaker doCreateServerHandShaker(String webSocketUrl, HttpRequest req) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(webSocketUrl, null, this.allowExtensions);
        return wsFactory.newHandshaker(req);
    }

    public Optional<ChannelFuture> close(String equipCode) {
        Channel channel = this.getDeviceManager().find(equipCode);
        if (channel != null) {
            if (channel.isActive()) {
                return Optional.of(channel.writeAndFlush((Object)new CloseWebSocketFrame()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
            }
            return Optional.of(channel.newSucceededFuture());
        }
        return Optional.empty();
    }

    public Optional<ChannelFuture> close(String equipCode, int statusCode, String reasonText) {
        Channel channel = this.getDeviceManager().find(equipCode);
        if (channel != null) {
            if (channel.isActive()) {
                return Optional.of(channel.writeAndFlush((Object)new CloseWebSocketFrame(statusCode, reasonText)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
            }
            return Optional.of(channel.newSucceededFuture());
        }
        return Optional.empty();
    }

    public Optional<ChannelFuture> close(String equipCode, boolean finalFragment, int rsv, ByteBuf binaryData) {
        Channel channel = this.getDeviceManager().find(equipCode);
        if (channel != null) {
            if (channel.isActive()) {
                return Optional.of(channel.writeAndFlush((Object)new CloseWebSocketFrame(finalFragment, rsv, binaryData)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
            }
            return Optional.of(channel.newSucceededFuture());
        }
        return Optional.empty();
    }

    public WebSocketInterceptor getInterceptor() {
        return (WebSocketInterceptor)super.getInterceptor();
    }

    public boolean isAllowExtensions() {
        return this.allowExtensions;
    }

    public void setAllowExtensions(boolean allowExtensions) {
        this.allowExtensions = allowExtensions;
    }
}

