/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.udp.impl;

import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import com.iteaj.iot.server.udp.impl.DefaultUdpProtocolType;
import com.iteaj.iot.server.udp.impl.DefaultUdpServerComponent;
import com.iteaj.iot.server.udp.impl.DefaultUdpServerMessage;
import com.iteaj.iot.udp.UdpMessageHead;
import com.iteaj.iot.udp.UdpProtocolException;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

public class DefaultUdpServerProtocol
extends ClientInitiativeProtocol<DefaultUdpServerMessage> {
    private DefaultUdpServerMessage response;

    public DefaultUdpServerProtocol(DefaultUdpServerMessage requestMessage) {
        super(requestMessage);
    }

    public void response(String write) {
        DefaultUdpServerMessage message = (DefaultUdpServerMessage)this.requestMessage();
        this.response = new DefaultUdpServerMessage(write.getBytes(StandardCharsets.UTF_8), message.getSender());
    }

    public void response(byte[] message) {
        DefaultUdpServerMessage requestMessage = (DefaultUdpServerMessage)this.requestMessage();
        this.response = new DefaultUdpServerMessage(message, requestMessage.getSender());
    }

    public void response(byte[] message, InetSocketAddress sender) {
        DefaultUdpServerMessage requestMessage = (DefaultUdpServerMessage)this.requestMessage();
        this.response = new DefaultUdpServerMessage(new UdpMessageHead(message), sender, requestMessage.getRecipient());
    }

    public void response(byte[] message, InetSocketAddress recipient, InetSocketAddress sender) {
        this.response = new DefaultUdpServerMessage(new UdpMessageHead(message), sender, recipient);
    }

    public static ChannelFuture write(byte[] message, String deviceSn) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultUdpServerMessage.class);
        if (serverComponent instanceof DefaultUdpServerComponent) {
            return ((DefaultUdpServerComponent)serverComponent).writeAndFlush(deviceSn, (Object)new DefaultUdpServerMessage(message), new Object[0]).get();
        }
        throw new UdpProtocolException("\u672a\u627e\u5230\u7ec4\u4ef6[" + DefaultUdpServerComponent.class.getSimpleName() + "]");
    }

    public static ChannelFuture write(byte[] message, String deviceSn, InetSocketAddress sender) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultUdpServerMessage.class);
        if (serverComponent instanceof DefaultUdpServerComponent) {
            DefaultUdpServerMessage serverMessage = new DefaultUdpServerMessage(message);
            return ((DefaultUdpServerComponent)serverComponent).writeAndFlush(deviceSn, (Object)serverMessage.setSender(sender), new Object[0]).get();
        }
        throw new UdpProtocolException("\u672a\u627e\u5230\u7ec4\u4ef6[" + DefaultUdpServerComponent.class.getSimpleName() + "]");
    }

    public static ChannelFuture write(byte[] message, InetSocketAddress recipient) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultUdpServerMessage.class);
        if (serverComponent instanceof DefaultUdpServerComponent) {
            return ((DefaultUdpServerComponent)serverComponent).writeAndFlush(null, (Object)new DefaultUdpServerMessage(message, recipient), new Object[0]).get();
        }
        throw new UdpProtocolException("\u672a\u627e\u5230\u7ec4\u4ef6[" + DefaultUdpServerComponent.class.getSimpleName() + "]");
    }

    public static ChannelFuture write(byte[] message, InetSocketAddress recipient, InetSocketAddress sender) {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(DefaultUdpServerMessage.class);
        if (serverComponent instanceof DefaultUdpServerComponent) {
            return ((DefaultUdpServerComponent)serverComponent).writeAndFlush(null, (Object)new DefaultUdpServerMessage(new UdpMessageHead(message), sender, recipient), new Object[0]).get();
        }
        throw new UdpProtocolException("\u672a\u627e\u5230\u7ec4\u4ef6[" + DefaultUdpServerComponent.class.getSimpleName() + "]");
    }

    @Override
    protected DefaultUdpServerMessage doBuildResponseMessage() {
        return this.response;
    }

    @Override
    protected void doBuildRequestMessage(DefaultUdpServerMessage requestMessage) {
    }

    @Override
    public ProtocolType protocolType() {
        return DefaultUdpProtocolType.DEFAULT;
    }
}

