/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.udp;

import com.iteaj.iot.Message;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.udp.UdpMessage;
import com.iteaj.iot.udp.UdpMessageBody;
import com.iteaj.iot.udp.UdpMessageHead;
import java.net.InetSocketAddress;

public abstract class UdpServerMessage
extends ServerMessage
implements UdpMessage {
    private InetSocketAddress sender;
    private InetSocketAddress recipient;

    public UdpServerMessage(byte[] message) {
        super(message);
    }

    public UdpServerMessage(UdpMessageHead head) {
        super((Message.MessageHead)head);
    }

    public UdpServerMessage(UdpMessageHead head, UdpMessageBody body) {
        super((Message.MessageHead)head, (Message.MessageBody)body);
    }

    public UdpServerMessage(byte[] message, InetSocketAddress recipient) {
        this(new UdpMessageHead(message), recipient);
    }

    public UdpServerMessage(UdpMessageHead head, InetSocketAddress recipient) {
        super((Message.MessageHead)head);
        this.recipient = recipient;
    }

    public UdpServerMessage(UdpMessageHead head, UdpMessageBody body, InetSocketAddress recipient) {
        super((Message.MessageHead)head, (Message.MessageBody)body);
        this.recipient = recipient;
    }

    public UdpServerMessage(UdpMessageHead head, InetSocketAddress sender, InetSocketAddress recipient) {
        super((Message.MessageHead)head);
        this.sender = sender;
        this.recipient = recipient;
    }

    public UdpServerMessage(UdpMessageHead head, UdpMessageBody body, InetSocketAddress sender, InetSocketAddress recipient) {
        super((Message.MessageHead)head, (Message.MessageBody)body);
        this.sender = sender;
        this.recipient = recipient;
    }

    protected abstract UdpMessageHead doBuild(byte[] var1);

    public String getChannelId() {
        return super.getChannelId();
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }

    public UdpServerMessage setSender(InetSocketAddress sender) {
        this.sender = sender;
        return this;
    }

    public InetSocketAddress getRecipient() {
        return this.recipient;
    }

    public UdpServerMessage setRecipient(InetSocketAddress recipient) {
        this.recipient = recipient;
        return this;
    }

    public UdpMessageHead getHead() {
        return (UdpMessageHead)super.getHead();
    }

    public UdpMessageBody getBody() {
        return (UdpMessageBody)super.getBody();
    }
}

