/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.udp;

import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.IotThreadManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.NotDeviceException;
import com.iteaj.iot.PortType;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.SocketDeviceManager;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.codec.adapter.SocketMessageDecoderDelegation;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.ServerComponent;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.codec.UdpServerProtocolEncoder;
import com.iteaj.iot.server.handle.ProtocolBusinessHandler;
import com.iteaj.iot.server.udp.UdpDeviceManager;
import com.iteaj.iot.server.udp.UdpEventManagerHandler;
import com.iteaj.iot.server.udp.UdpIdleState;
import com.iteaj.iot.server.udp.UdpServerMessage;
import com.iteaj.iot.udp.UdpProtocolException;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Optional;

public abstract class UdpServerComponent<M extends UdpServerMessage>
extends SocketServerComponent<M, DatagramPacket> {
    public UdpServerComponent(ConnectProperties connectProperties) {
        super(connectProperties);
    }

    public SocketMessage proxy(ChannelHandlerContext ctx, DatagramPacket in) throws Exception {
        return super.proxy(ctx, (ReferenceCounted)in);
    }

    public List<? extends SocketMessage> decodes(ChannelHandlerContext ctx, DatagramPacket in) throws Exception {
        return super.decodes(ctx, (ReferenceCounted)in);
    }

    @Override
    public AbstractBootstrap initParentChannel() {
        return this.initOptions((Bootstrap)((Bootstrap)new Bootstrap().group(IotThreadManager.instance().getWorkerGroup())).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) throws Exception {
                UdpServerComponent.this.getDeviceManager().setChannel((DatagramChannel)ch);
                UdpServerComponent.this.doInitParentChannel(ch.pipeline());
            }
        });
    }

    protected Bootstrap initOptions(Bootstrap bootstrap) {
        return bootstrap;
    }

    protected void doInitParentChannel(ChannelPipeline ch) {
        ch.addFirst("ServerProtocolEncoder", (ChannelHandler)UdpServerProtocolEncoder.getInstance());
        ChannelInboundHandlerAdapter decoder = this.getMessageDecoder();
        if (decoder == null) {
            throw new ProtocolException("\u672a\u6307\u5b9a\u8bbe\u5907\u62a5\u6587\u89e3\u7801\u5668\uff1a" + this.getName());
        }
        if (decoder instanceof SocketMessageDecoderDelegation && ((SocketMessageDecoderDelegation)decoder).getDelegation() == null) {
            UdpServerComponent udpServerComponent = this;
            ((SocketMessageDecoderDelegation)decoder).setDelegation((SocketMessageDecoder)udpServerComponent);
        }
        ch.addFirst("ServerProtocolDecoder", (ChannelHandler)decoder);
        ch.addLast("EventManagerHandler", (ChannelHandler)UdpEventManagerHandler.getInstance());
        ch.addLast("ServerServiceHandler", (ChannelHandler)ProtocolBusinessHandler.getInstance());
        this.doInitChannel(ch);
    }

    @Override
    public Optional<ChannelFuture> writeAndFlush(String equipCode, Object msg, Object ... args) {
        if (msg instanceof Protocol) {
            return this.writeAndFlush(equipCode, (Protocol)msg);
        }
        if (msg instanceof Message) {
            if (!(msg instanceof UdpServerMessage)) {
                throw new UdpProtocolException("udp\u534f\u8bae\u53ea\u652f\u6301\u670d\u52a1\u7aef\u62a5\u6587\u7c7b\u578b[" + UdpServerMessage.class.getSimpleName() + "]");
            }
            if (((UdpServerMessage)((Object)msg)).getRecipient() == null) {
                UdpIdleState udpIdleState = this.getDeviceManager().find(equipCode);
                if (udpIdleState == null) {
                    return Optional.of(this.getChannel().newFailedFuture((Throwable)NotDeviceException.DEFAULT));
                }
                ((UdpServerMessage)((Object)msg)).setRecipient(udpIdleState.getAddress());
            }
        }
        return this.getDeviceManager().writeAndFlush(equipCode, msg, new Object[0]);
    }

    @Override
    public Optional<ChannelFuture> writeAndFlush(String equipCode, Protocol protocol) {
        Message requestMessage = protocol.requestMessage();
        if (!(requestMessage instanceof UdpServerMessage)) {
            throw new UdpProtocolException("udp\u534f\u8bae\u53ea\u652f\u6301\u670d\u52a1\u7aef\u62a5\u6587\u7c7b\u578b[" + UdpServerMessage.class.getSimpleName() + "]");
        }
        if (((UdpServerMessage)requestMessage).getRecipient() == null) {
            UdpIdleState udpIdleState = this.getDeviceManager().find(equipCode);
            if (udpIdleState == null) {
                return Optional.of(this.getChannel().newFailedFuture((Throwable)NotDeviceException.DEFAULT));
            }
            ((UdpServerMessage)requestMessage).setRecipient(udpIdleState.getAddress());
        }
        return this.getDeviceManager().writeAndFlush(equipCode, protocol);
    }

    @Override
    public UdpDeviceManager getDeviceManager() {
        return (UdpDeviceManager)super.getDeviceManager();
    }

    @Override
    protected SocketDeviceManager createDeviceManager() {
        return (SocketDeviceManager)FrameworkManager.createDeviceManager((ServerComponent)this);
    }

    protected NioDatagramChannel getChannel() {
        return (NioDatagramChannel)super.getChannel();
    }

    public PortType getPortType() {
        return PortType.Udp;
    }

    @Override
    public synchronized void close() {
        if (this.isStart()) {
            super.close();
        }
    }
}

