/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.udp;

import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.event.ClientStatus;
import com.iteaj.iot.event.IotEvent;
import com.iteaj.iot.event.StatusEvent;
import com.iteaj.iot.server.udp.UdpIdleState;
import com.iteaj.iot.server.udp.UdpServerComponent;
import com.iteaj.iot.server.udp.UdpServerMessage;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.StringUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class UdpEventManagerHandler
extends ChannelDuplexHandler {
    private static UdpEventManagerHandler instance = new UdpEventManagerHandler();
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected UdpEventManagerHandler() {
    }

    public static UdpEventManagerHandler getInstance() {
        return instance;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof UdpServerMessage) {
            UdpServerMessage message = (UdpServerMessage)((Object)msg);
            String equipCode = message.getHead().getEquipCode();
            UdpServerComponent serverComponent = (UdpServerComponent)((Object)ctx.channel().attr(CoreConst.COMPONENT).get());
            ConnectProperties config = serverComponent.config();
            if (!StringUtil.isNullOrEmpty((String)equipCode) && config.getReaderIdleTime() > 0L) {
                UdpIdleState idleState = serverComponent.getDeviceManager().find(equipCode);
                if (idleState == null) {
                    long currentTimeMillis = System.currentTimeMillis();
                    idleState = new UdpIdleState(equipCode, currentTimeMillis, config, message.getSender());
                    serverComponent.getDeviceManager().add(equipCode, idleState);
                    ScheduledFuture schedule = ctx.executor().schedule((Runnable)new IdleTask(idleState, ctx), config.getReaderIdleTime(), TimeUnit.SECONDS);
                    idleState.setScheduledFuture(schedule);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u5ba2\u6237\u7aef\u4e0a\u7ebf({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{serverComponent.getName(), equipCode, message.getSender()});
                    }
                    FrameworkManager.publishEvent((IotEvent)new StatusEvent((Object)equipCode, ClientStatus.online, (FrameworkComponent)serverComponent));
                } else {
                    ScheduledFuture future;
                    idleState.setAddress(message.getSender());
                    idleState.setLastOfMills(System.currentTimeMillis());
                    if (config.getReaderIdleTime() > 0L && (future = idleState.getScheduledFuture()) == null) {
                        ScheduledFuture schedule = ctx.executor().schedule((Runnable)new IdleTask(idleState, ctx), config.getReaderIdleTime(), TimeUnit.SECONDS);
                        idleState.setScheduledFuture(schedule);
                    }
                }
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof UdpIdleState) {
            UdpServerComponent serverComponent = (UdpServerComponent)((Object)ctx.channel().attr(CoreConst.COMPONENT).get());
            Object idle = serverComponent.idle(((UdpIdleState)evt).getEquipCode(), IdleState.READER_IDLE);
            if (idle instanceof IdleState) {
                UdpIdleState remove = serverComponent.getDeviceManager().remove(((UdpIdleState)evt).getEquipCode());
                if (this.logger.isDebugEnabled() && remove != null) {
                    this.logger.debug("\u5ba2\u6237\u7aef\u8d85\u65f6\u4e0b\u7ebf({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {} - \u72b6\u6001: \u4e0b\u7ebf\u6210\u529f", new Object[]{serverComponent.getName(), remove.getEquipCode(), remove.getAddress()});
                }
                if (remove != null) {
                    FrameworkManager.publishEvent((IotEvent)new StatusEvent((Object)remove.getEquipCode(), ClientStatus.offline, (FrameworkComponent)serverComponent));
                }
            } else if (idle != null) {
                String equipCode = ((UdpIdleState)evt).getEquipCode();
                serverComponent.writeAndFlush(equipCode, idle, new Object[0]);
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    protected class IdleTask
    implements Runnable {
        private UdpIdleState idleState;
        private ChannelHandlerContext ctx;

        public IdleTask(UdpIdleState idleState, ChannelHandlerContext ctx) {
            this.ctx = ctx;
            this.idleState = idleState;
        }

        @Override
        public void run() {
            try {
                ConnectProperties config = this.idleState.getConfig();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.idleState.getLastOfMills());
                if (seconds >= config.getReaderIdleTime()) {
                    this.idleState.setScheduledFuture(null);
                    UdpEventManagerHandler.this.userEventTriggered(this.ctx, this.idleState);
                } else {
                    ScheduledFuture schedule = this.ctx.executor().schedule((Runnable)this, config.getReaderIdleTime() - seconds, TimeUnit.SECONDS);
                    this.idleState.setScheduledFuture(schedule);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

