/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.protocol;

import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.TcpServerComponent;
import com.iteaj.iot.server.protocol.ServerInitiativeProtocol;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;

public abstract class ServerInitiativeSyncProtocol<M extends ServerMessage>
extends ServerInitiativeProtocol<M> {
    public ServerInitiativeSyncProtocol() {
        this.sync(3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request() throws ProtocolException {
        try {
            this.buildRequestMessage();
            if (null == this.requestMessage()) {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u8bf7\u6c42\u62a5\u6587");
            }
            TcpServerComponent component = (TcpServerComponent)FrameworkManager.getServerComponent(this.requestMessage().getClass());
            if (component == null) {
                throw new IllegalArgumentException("\u83b7\u53d6\u4e0d\u5230[" + this.responseMessage().getClass().getSimpleName() + "]\u5bf9\u5e94\u7684\u7ec4\u4ef6");
            }
            Channel channel = component.getDeviceManager().find(this.getEquipCode());
            if (channel == null || !channel.isActive()) {
                this.setExecStatus(ExecStatus.offline).exec(this.getProtocolHandle());
                return;
            }
            this.syncDeadValidate(channel);
            this.requestMessageHandle(component, channel);
            if (this.isSyncRequest()) {
                if (!this.isRelation()) {
                    throw new IllegalStateException("\u540c\u6b65\u6267\u884c\u5fc5\u987b\u5173\u8054\u534f\u8bae(\u5c06\u5bfc\u81f4\u9501\u4e0d\u80fd\u91ca\u653e)");
                }
            } else if (this.isRelation()) {
                throw new IllegalStateException("\u975e\u540c\u6b65\u6267\u884c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5173\u8054\u534f\u8bae");
            }
            Channel channel2 = channel;
            synchronized (channel2) {
                boolean await;
                if (this.writeAndFlush(component) != ExecStatus.success) {
                    this.exec(this.getProtocolHandle());
                    return;
                }
                if (this.isSyncRequest() && !(await = this.getDownLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS))) {
                    this.execTimeoutHandle(component);
                }
                this.exec(this.getProtocolHandle());
            }
        }
        catch (InterruptedException e) {
            throw new ProtocolException((Throwable)e, (Object)this);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                throw e;
            }
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void requestMessageHandle(SocketServerComponent component, Channel channel) {
        super.requestMessageHandle(component, channel);
        if (this.requestMessage().getHead().getMessageId() == null) {
            this.requestMessage().getHead().setMessageId(channel.id().asShortText());
        }
    }

    public ServerInitiativeSyncProtocol setExecStatus(ExecStatus execStatus) {
        return (ServerInitiativeSyncProtocol)super.setExecStatus(execStatus);
    }

    @Override
    public abstract ProtocolType protocolType();
}

