/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.protocol;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.FreeProtocolHandle;
import com.iteaj.iot.Message;
import com.iteaj.iot.NotDeviceException;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolHandle;
import com.iteaj.iot.ProtocolPreservable;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.business.ProtocolHandleFactory;
import com.iteaj.iot.client.UnWritableProtocolException;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.ServerSocketProtocol;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.TcpServerComponent;
import com.iteaj.iot.server.protocol.ServerProtocolCallHandle;
import com.iteaj.iot.server.udp.UdpDeviceManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.DatagramChannel;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class ServerInitiativeProtocol<M extends ServerMessage>
extends ServerSocketProtocol<M>
implements ProtocolPreservable {
    private long timeout = 10000L;
    private CountDownLatch downLatch;
    private FreeProtocolHandle freeProtocolHandle;

    public AbstractProtocol exec(ProtocolHandleFactory factory) {
        if (!this.isSyncRequest()) {
            return this.exec(this.getProtocolHandle());
        }
        this.releaseLock();
        return null;
    }

    public ServerInitiativeProtocol buildRequestMessage() {
        try {
            this.requestMessage = this.doBuildRequestMessage();
        }
        catch (IOException e) {
            throw new ProtocolException("\u6784\u5efa\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38", e.getCause());
        }
        return this;
    }

    protected abstract M doBuildRequestMessage() throws IOException;

    public ServerInitiativeProtocol buildResponseMessage() {
        if (this.logger.isDebugEnabled() && this.responseMessage() != null) {
            Message.MessageHead head = this.responseMessage().getHead();
            String messageId = head != null ? head.getMessageId() : null;
            this.logger.debug("\u670d\u52a1\u7aef\u4e3b\u52a8\u534f\u8bae \u5ba2\u6237\u7aef\u54cd\u5e94\u5e73\u53f0 - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u534f\u8bae\u7c7b\u578b: {} - messageId: {} - \u62a5\u6587: {}", new Object[]{this.getEquipCode(), this.protocolType().getType(), messageId, this.responseMessage()});
        }
        this.doBuildResponseMessage(this.responseMessage());
        return this;
    }

    protected abstract void doBuildResponseMessage(M var1);

    public Object relationKey() {
        return this.requestMessage().getHead().getMessageId();
    }

    public void request(ServerProtocolCallHandle handle) throws ProtocolException {
        this.request((FreeProtocolHandle)handle);
    }

    public <P extends ServerInitiativeProtocol<M>> void request(FreeProtocolHandle<P> handle) throws ProtocolException {
        this.freeProtocolHandle = handle;
        this.request();
    }

    public void request() throws ProtocolException {
        try {
            DatagramChannel channel;
            this.buildRequestMessage();
            if (null == this.requestMessage()) {
                throw new IllegalStateException("\u4e0d\u5b58\u5728\u8bf7\u6c42\u62a5\u6587");
            }
            SocketServerComponent component = (SocketServerComponent)FrameworkManager.getComponent(this.requestMessage().getClass());
            if (component == null) {
                throw new IllegalStateException("\u83b7\u53d6\u4e0d\u5230[" + this.responseMessage().getClass().getSimpleName() + "]\u5bf9\u5e94\u7684\u7ec4\u4ef6");
            }
            if (component instanceof TcpServerComponent) {
                channel = (Channel)component.getDeviceManager().find(this.getEquipCode());
                if (channel instanceof Channel) {
                    if (!channel.isActive()) {
                        this.setExecStatus(ExecStatus.offline);
                    }
                } else {
                    this.setExecStatus(ExecStatus.offline);
                }
                if (this.getExecStatus() != ExecStatus.success) {
                    this.exec(this.getProtocolHandle());
                    return;
                }
            } else {
                channel = ((UdpDeviceManager)component.getDeviceManager()).getChannel();
            }
            this.requestMessageHandle(component, (Channel)channel);
            if (this.writeAndFlush(component) != ExecStatus.success) {
                this.exec(this.getProtocolHandle());
                return;
            }
            if (this.isSyncRequest()) {
                this.syncDeadValidate((Channel)channel);
                boolean await = this.getDownLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS);
                if (!await) {
                    this.execTimeoutHandle(component);
                }
                this.exec(this.getProtocolHandle());
            }
        }
        catch (InterruptedException e) {
            throw new ProtocolException("\u6267\u884c\u4e2d\u65ad", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                throw e;
            }
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    protected void requestMessageHandle(SocketServerComponent component, Channel channel) {
        this.requestMessage().setChannelId(channel.id().asShortText());
    }

    protected ExecStatus writeAndFlush(SocketServerComponent component) throws InterruptedException {
        ExecStatus result = this.getExecStatus();
        ChannelFuture future = component.writeAndFlush(this.getEquipCode(), (Protocol)this).orElse(null);
        if (future == null) {
            this.setReason("\u8bbe\u5907\u4e0d\u5728\u7ebf");
            this.setExecStatus(ExecStatus.offline);
            return this.getExecStatus();
        }
        if (future.isDone()) {
            Throwable cause = future.cause();
            if (cause instanceof NotDeviceException) {
                this.setReason("\u8bbe\u5907\u4e0d\u5728\u7ebf");
                this.setExecStatus(ExecStatus.offline);
                return this.getExecStatus();
            }
        } else {
            if (!future.await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                this.setReason("\u8bf7\u6c42\u8d85\u65f6");
                this.setExecStatus(ExecStatus.timeout);
                return this.getExecStatus();
            }
            if (!future.isSuccess()) {
                if (future.cause() instanceof UnWritableProtocolException) {
                    result = ExecStatus.notWritable;
                    this.setExecStatus(result);
                } else {
                    result = ExecStatus.fail;
                    this.setExecStatus(result);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("\u53d1\u9001\u5931\u8d25", future.cause());
                }
                this.setReason(future.cause() != null ? future.cause().getMessage() : this.getExecStatus().desc);
            }
        }
        return result;
    }

    protected void syncDeadValidate(Channel channel) {
        if (channel.eventLoop().inEventLoop()) {
            throw new IllegalThreadStateException("\u8c03\u7528\u7ebf\u7a0b\u548c\u5de5\u4f5c\u7ebf\u7a0b\u76f8\u540c\u5c06\u5bfc\u81f4\u6b7b\u9501");
        }
    }

    protected void execTimeoutHandle(SocketServerComponent component) {
        this.setReason("\u8bf7\u6c42\u8d85\u65f6");
        this.setExecStatus(ExecStatus.timeout);
        if (this.isRelation()) {
            try {
                this.syncRemoveTimeoutProtocol(component);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    protected void syncRemoveTimeoutProtocol(SocketServerComponent component) {
        Message.MessageHead head = this.requestMessage().getHead();
        Object protocol = component.protocolFactory().get((Object)head.getMessageId());
        if (protocol != null && protocol == this) {
            component.protocolFactory().remove((Object)head.getMessageId());
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("\u540c\u6b65\u8d85\u65f6({}) \u8d85\u65f6\u79fb\u9664({}ms) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - messageId: {} - \u534f\u8bae\u7c7b\u578b: {}", new Object[]{component.getName(), this.getTimeout(), head.getEquipCode(), head.getMessageId(), this.protocolType()});
            }
        }
    }

    public <P extends ServerInitiativeProtocol> P sync(long timeout) {
        this.setDownLatch(new CountDownLatch(1));
        return (P)((Object)this.timeout(timeout));
    }

    public ServerInitiativeProtocol exec(ProtocolHandle handle) {
        this.buildResponseMessage();
        if (handle != null) {
            handle.handle((Protocol)this);
        }
        return null;
    }

    public String getEquipCode() {
        return super.getEquipCode();
    }

    protected ProtocolHandle getProtocolHandle() {
        FreeProtocolHandle protocolHandle = this.getFreeProtocolHandle();
        if (protocolHandle == null) {
            protocolHandle = FrameworkManager.getProtocolHandle(((Object)((Object)this)).getClass());
        }
        return protocolHandle;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public FreeProtocolHandle getFreeProtocolHandle() {
        return this.freeProtocolHandle;
    }

    public ServerInitiativeProtocol setFreeProtocolHandle(FreeProtocolHandle freeProtocolHandle) {
        this.freeProtocolHandle = freeProtocolHandle;
        return this;
    }

    public ServerInitiativeProtocol timeout(long timeout) {
        if (timeout < 0L) {
            throw new ProtocolException("\u8d85\u65f6\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e 0(ms)");
        }
        this.timeout = timeout;
        return this;
    }

    public abstract ProtocolType protocolType();

    public boolean isSyncRequest() {
        return this.getDownLatch() != null;
    }

    public void releaseLock() {
        if (this.isSyncRequest()) {
            this.getDownLatch().countDown();
        }
    }

    protected CountDownLatch getDownLatch() {
        return this.downLatch;
    }

    protected void setDownLatch(CountDownLatch downLatch) {
        this.downLatch = downLatch;
    }
}

