/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.protocol;

import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.protocol.CommonProtocolType;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProtocol
extends ClientInitiativeProtocol<ServerMessage> {
    private SocketServerComponent serverComponent;
    private static Logger logger = LoggerFactory.getLogger(HeartbeatProtocol.class);

    protected HeartbeatProtocol(ServerMessage requestMessage) {
        super(requestMessage);
    }

    public static HeartbeatProtocol getInstance(ServerMessage requestMessage) {
        return new HeartbeatProtocol(requestMessage);
    }

    @Override
    public ProtocolType protocolType() {
        return CommonProtocolType.Common_Heart;
    }

    @Override
    protected ServerMessage doBuildResponseMessage() {
        return null;
    }

    public SocketServerComponent getServerComponent() {
        return this.serverComponent;
    }

    public HeartbeatProtocol setServerComponent(SocketServerComponent serverComponent) {
        this.serverComponent = serverComponent;
        return this;
    }

    @Override
    protected void doBuildRequestMessage(ServerMessage requestMessage) {
        if (logger.isTraceEnabled()) {
            Message.MessageHead head = requestMessage.getHead();
            logger.trace("\u5ba2\u6237\u7aef\u5fc3\u8df3({}) \u5ba2\u6237\u7aef\u7f16\u53f7\uff1a{} - messageId\uff1a{} - \u534f\u8bae\uff1a{}", new Object[]{this.serverComponent.getName(), head.getEquipCode(), head.getMessageId(), head.getType()});
        }
    }
}

