/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.protocol;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.Message;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolHandle;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.business.ProtocolHandleFactory;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.ServerSocketProtocol;

public abstract class ClientInitiativeProtocol<M extends ServerMessage>
extends ServerSocketProtocol<M> {
    public ClientInitiativeProtocol(M requestMessage) {
        this.requestMessage = requestMessage;
    }

    public AbstractProtocol exec(ProtocolHandleFactory factory) {
        this.buildRequestMessage();
        return this.exec(factory.getHandle(((Object)((Object)this)).getClass()));
    }

    public AbstractProtocol exec(ProtocolHandle business) {
        if (null != business) {
            business.handle((Protocol)this);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.warn("\u5ba2\u6237\u7aef\u4e3b\u52a8\u8bf7\u6c42 \u6ca1\u6709\u6307\u5b9a[ServerProtocolHandle] - \u534f\u8bae\u7c7b\u578b: {} - \u534f\u8bae\u63cf\u8ff0: {} - \u8bf4\u660e: \u4e0d\u5bf9\u6b64\u534f\u8bae\u505a\u4e1a\u52a1\u5904\u7406", (Object)this.protocolType().getType(), (Object)this.desc());
        }
        return this.buildResponseMessage();
    }

    public ClientInitiativeProtocol buildResponseMessage() {
        if (null == this.requestMessage()) {
            throw new IllegalStateException("\u4e0d\u5b58\u5728\u8bf7\u6c42\u62a5\u6587\uff1a" + this.requestMessage());
        }
        this.responseMessage = this.doBuildResponseMessage();
        if (this.responseMessage != null) {
            return this;
        }
        return null;
    }

    protected abstract M doBuildResponseMessage();

    public ClientInitiativeProtocol buildRequestMessage() {
        this.doBuildRequestMessage(this.requestMessage());
        Message.MessageHead messageHead = this.requestMessage().getHead();
        if (this.logger.isTraceEnabled() && messageHead != null) {
            this.logger.trace("\u5ba2\u6237\u7aef\u4e3b\u52a8\u534f\u8bae \u6784\u5efa\u8bf7\u6c42\u62a5\u6587 - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u534f\u8bae\u7c7b\u578b: {}", (Object)this.getEquipCode(), (Object)this.protocolType());
        }
        return this;
    }

    protected abstract void doBuildRequestMessage(M var1);

    public String desc() {
        return this.protocolType().getDesc();
    }

    public abstract ProtocolType protocolType();
}

