/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.manager;

import com.iteaj.iot.ChannelManager;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.NotDeviceException;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.client.UnWritableProtocolException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpDeviceManager
extends DefaultChannelGroup
implements ChannelManager {
    private final EventExecutor executor;
    private static Logger logger = LoggerFactory.getLogger(TcpDeviceManager.class);
    private final ConcurrentMap<String, Channel> registerChannels = PlatformDependent.newConcurrentHashMap();

    public TcpDeviceManager(String name, EventExecutor executor) {
        super(name, executor);
        this.executor = executor;
    }

    public TcpDeviceManager(String name, EventExecutor executor, boolean stayClosed) {
        super(name, executor, stayClosed);
        this.executor = executor;
    }

    public Channel add(String equipCode, Channel channel) {
        this.add(channel);
        return this.registerChannels.put(equipCode, channel);
    }

    public int useSize() {
        return this.registerChannels.size();
    }

    public Collection<Channel> devices() {
        return Collections.unmodifiableCollection(this.registerChannels.values());
    }

    public Channel find(String equipCode) {
        return (Channel)this.registerChannels.get(equipCode);
    }

    public Channel remove(String equipCode) {
        Channel remove = (Channel)this.registerChannels.get(equipCode);
        if (remove != null) {
            this.remove((Object)equipCode);
        }
        return remove;
    }

    public boolean close(String equipCode) {
        Channel channel = this.find(equipCode);
        if (channel != null) {
            if (channel.isActive()) {
                return channel.close().syncUninterruptibly().isSuccess();
            }
            return true;
        }
        return true;
    }

    public boolean isClose(String equipCode) {
        Channel channel = this.find(equipCode);
        if (channel == null) {
            return true;
        }
        return !channel.isActive();
    }

    public boolean isEmpty() {
        return this.registerChannels.isEmpty();
    }

    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.registerChannels.containsKey(o);
        }
        return super.contains(o);
    }

    public boolean remove(Object o) {
        if (o instanceof Channel) {
            String deviceSn = (String)((Channel)o).attr(CoreConst.EQUIP_CODE).get();
            if (deviceSn instanceof String) {
                Channel channel = this.find(deviceSn);
                if (channel == o) {
                    this.registerChannels.remove(deviceSn);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("\u5ba2\u6237\u7aef\u7ba1\u7406({}) \u79fb\u9664\u975e\u6d3b\u52a8\u5ba2\u6237\u7aef - \u5ba2\u6237\u7aef\u7f16\u53f7: {}", (Object)this.name(), (Object)deviceSn);
                }
            }
        } else if (o instanceof String) {
            o = this.registerChannels.remove(o);
        } else {
            throw new IllegalArgumentException("\u53ea\u652f\u6301\u4f7f\u7528[String or Channel]\u79fb\u9664\u5ba2\u6237\u7aef");
        }
        boolean remove = super.remove(o);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5ba2\u6237\u7aef\u7ba1\u7406({}) \u5ba2\u6237\u7aef\u7edf\u8ba1 - \u603b\u8fde\u63a5\u6570: {} - \u603b\u6ce8\u518c\u6570: {}", new Object[]{this.name(), this.size(), this.registerChannels.size()});
        }
        return remove;
    }

    public void clear() {
        super.clear();
        this.registerChannels.clear();
    }

    public Optional<ChannelFuture> writeAndFlush(String equipCode, Object msg, Object ... args) {
        if (msg instanceof Protocol) {
            return this.writeAndFlush(equipCode, (Protocol)msg);
        }
        if (StringUtils.isBlank((CharSequence)equipCode)) {
            throw new IllegalArgumentException("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == msg) {
            throw new IllegalArgumentException("\u8bf7\u4f20\u5165\u8981\u53d1\u9001\u7684\u534f\u8bae\u62a5\u6587");
        }
        Channel channel = this.find(equipCode);
        if (null == channel) {
            return Optional.empty();
        }
        if (!channel.isActive()) {
            this.remove(equipCode);
            return Optional.of(channel.newFailedFuture((Throwable)NotDeviceException.DEFAULT));
        }
        if (!channel.isWritable()) {
            return Optional.of(channel.newFailedFuture((Throwable)new UnWritableProtocolException(msg, channel.bytesBeforeWritable(), channel.bytesBeforeUnwritable())));
        }
        return Optional.of(channel.writeAndFlush(msg));
    }

    public Optional<ChannelFuture> writeAndFlush(String equipCode, Protocol protocol) {
        if (StringUtils.isBlank((CharSequence)equipCode)) {
            throw new IllegalArgumentException("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == protocol) {
            throw new IllegalArgumentException("\u8bf7\u4f20\u5165\u8981\u53d1\u9001\u7684\u534f\u8bae\u62a5\u6587");
        }
        Channel channel = this.find(equipCode);
        if (null == channel) {
            return Optional.empty();
        }
        if (!channel.isActive()) {
            this.remove(equipCode);
            logger.warn("\u8bbe\u5907\u5728\u7ebf\u7ba1\u7406({}) \u8bbe\u5907\u65ad\u7ebf - \u8bbe\u5907\u7f16\u53f7: {} - \u5df2\u8fde\u63a5\uff1a{} - \u5df2\u6ce8\u518c\uff1a{} - \u534f\u8bae: {}", new Object[]{this.name(), equipCode, this.size(), this.useSize(), protocol.protocolType()});
            return Optional.of(channel.newFailedFuture((Throwable)NotDeviceException.DEFAULT));
        }
        if (!channel.isWritable()) {
            return Optional.of(channel.newFailedFuture((Throwable)new UnWritableProtocolException((Object)protocol, channel.bytesBeforeWritable(), channel.bytesBeforeUnwritable())));
        }
        return Optional.of(channel.writeAndFlush((Object)protocol));
    }

    protected EventExecutor getExecutor() {
        return this.executor;
    }
}

