/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.handle;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.BusinessAction;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.event.ExceptionEvent;
import com.iteaj.iot.event.ExceptionEventListener;
import com.iteaj.iot.event.IotEvent;
import com.iteaj.iot.message.UnParseBodyMessage;
import com.iteaj.iot.protocol.NoneDealProtocol;
import com.iteaj.iot.server.ServerSocketProtocol;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import com.iteaj.iot.server.protocol.HeartbeatProtocol;
import com.iteaj.iot.server.protocol.ServerInitiativeProtocol;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ProtocolBusinessHandler
extends SimpleChannelInboundHandler<UnParseBodyMessage> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static ProtocolBusinessHandler businessHandler = new ProtocolBusinessHandler();

    public static ProtocolBusinessHandler getInstance() {
        return businessHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, UnParseBodyMessage msg) throws Exception {
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getComponent(msg.getClass());
        if (serverComponent == null) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u7ec4\u4ef6\u5931\u8d25 \u5bf9\u5e94\u62a5\u6587\u7c7b\u578b: {}", msg.getClass());
            return;
        }
        Message.MessageHead head = msg.getHead();
        try {
            AbstractProtocol protocol = serverComponent.getProtocol((SocketMessage)msg);
            if (protocol instanceof HeartbeatProtocol) {
                HeartbeatProtocol heartbeatProtocol = ((HeartbeatProtocol)protocol).setServerComponent(serverComponent);
                FrameworkManager.getInstance();
                heartbeatProtocol.exec(FrameworkManager.getHandleFactory());
                return;
            }
            if (protocol instanceof ServerSocketProtocol) {
                if (protocol instanceof ServerInitiativeProtocol) {
                    protocol.setResponseMessage((Message)msg);
                } else if (protocol instanceof ClientInitiativeProtocol) {
                    if (protocol.requestMessage() == null) {
                        protocol.setRequestMessage((Message)msg);
                    }
                } else {
                    ctx.fireChannelRead((Object)msg);
                }
                if (protocol instanceof BusinessAction) {
                    BusinessAction businessAction = (BusinessAction)protocol;
                    FrameworkManager.getInstance();
                    AbstractProtocol exec = businessAction.exec(FrameworkManager.getHandleFactory());
                    if (exec instanceof ClientInitiativeProtocol) {
                        this.writeProtocol(ctx, exec);
                        return;
                    }
                }
            } else {
                if (protocol instanceof NoneDealProtocol) {
                    return;
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("\u627e\u4e0d\u5230\u534f\u8bae({}) - \u534f\u8bae\u7c7b\u578b\uff1a{} - \u5ba2\u6237\u7aef\u7f16\u53f7\uff1a{} - messageId: {}", new Object[]{serverComponent.getName(), head.getType(), head.getEquipCode(), head.getMessageId()});
                }
            }
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    private void writeProtocol(ChannelHandlerContext ctx, AbstractProtocol exec) {
        Message.MessageHead responseHead = exec.responseMessage().getHead();
        String desc = "\u5e73\u53f0\u54cd\u5e94\u5ba2\u6237\u7aef";
        ctx.writeAndFlush((Object)exec).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            String msg1;
            String string = msg1 = future.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - messageId: {} - \u534f\u8bae\u7c7b\u578b: {}", new Object[]{desc, msg1, responseHead.getEquipCode(), responseHead.getMessageId(), responseHead.getType()});
            }
        }));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Object o = ctx.channel().attr(CoreConst.EQUIP_CODE).get();
        String equipCode = o == null ? null : (String)o;
        InetSocketAddress address = (InetSocketAddress)ctx.channel().localAddress();
        SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getTcpComponent((Integer)address.getPort());
        this.logger.error("\u534f\u8bae\u5f02\u5e38({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u9519\u8bef\u4fe1\u606f: {} - \u5904\u7406\u65b9\u5f0f\uff1a\u521b\u5efa\u76d1\u542c\u5668[{}]\u76d1\u542c\u5f02\u5e38\u4e8b\u4ef6({})", new Object[]{serverComponent.getName(), equipCode, cause.getMessage(), ExceptionEventListener.class.getSimpleName(), ExceptionEvent.class.getSimpleName(), cause});
        FrameworkManager.publishEvent((IotEvent)new ExceptionEvent(cause, equipCode).setComponent((FrameworkComponent)serverComponent));
    }
}

