/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.handle;

import com.iteaj.iot.ChannelManager;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.codec.filter.RegisterParams;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.event.ClientStatus;
import com.iteaj.iot.event.IotEvent;
import com.iteaj.iot.event.OfflineReason;
import com.iteaj.iot.event.StatusEvent;
import com.iteaj.iot.message.UnParseBodyMessage;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.TcpServerComponent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Attribute;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EventManagerHandler
extends SimpleChannelInboundHandler<UnParseBodyMessage> {
    private static EventManagerHandler managerHandler = new EventManagerHandler();
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public static EventManagerHandler getInstance() {
        return managerHandler;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            String equipCode = (String)ctx.channel().attr(CoreConst.EQUIP_CODE).get();
            TcpServerComponent component = (TcpServerComponent)((Object)ctx.channel().attr(CoreConst.COMPONENT).get());
            Object idle = component.idle(equipCode, ((IdleStateEvent)evt).state());
            if (idle instanceof IdleState) {
                ConnectProperties config = component.config();
                long timeout = idle == IdleState.ALL_IDLE ? config.getAllIdleTime() : (idle == IdleState.READER_IDLE ? config.getReaderIdleTime() : config.getWriterIdleTime());
                ctx.channel().attr(CoreConst.CLIENT_TIMEOUT_CLOSED).set((Object)timeout);
                ctx.channel().close();
            } else if (idle != null) {
                component.writeAndFlush(equipCode, idle, new Object[0]);
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void channelRead0(ChannelHandlerContext ctx, UnParseBodyMessage msg) throws Exception {
        if (msg.getHead() == null) {
            this.logger.error("\u672a\u6784\u5efa\u51fa\u62a5\u6587\u5934[{}#doBuild(byte[])]", (Object)msg.getClass().getSimpleName());
            return;
        }
        String equipCode = (String)ctx.channel().attr(CoreConst.EQUIP_CODE).get();
        if (null == equipCode) {
            SocketServerComponent component = (SocketServerComponent)FrameworkManager.getServerComponent(msg.getClass());
            ChannelManager deviceManager = (ChannelManager)component.getDeviceManager();
            Message.MessageHead messageHead = component.register(msg.getHead(), new RegisterParams(msg, ctx.channel(), (FrameworkComponent)component));
            equipCode = messageHead.getEquipCode();
            if (equipCode == null) {
                this.logger.error("\u6ce8\u518c\u8bbe\u5907\u7f16\u53f7({}) \u62a5\u6587\u5934\u672a\u8bbe\u7f6e\u8bbe\u5907\u7f16\u53f7\u5bfc\u81f4\u8bbe\u5907\u6ce8\u518c\u5931\u8d25 - \u5ba2\u6237\u7aef\u5730\u5740: {}", (Object)component.getName(), (Object)ctx.channel().remoteAddress());
                return;
            }
            StatusEvent statusEvent = null;
            SocketServerComponent socketServerComponent = component;
            // MONITORENTER : socketServerComponent
            Object ifAbsent = ctx.channel().attr(CoreConst.EQUIP_CODE).setIfAbsent((Object)equipCode);
            if (ifAbsent == null) {
                Channel channel = (Channel)deviceManager.find(equipCode);
                if (channel != null && channel != ctx.channel()) {
                    if (channel.isActive()) {
                        if (component.isOverride()) {
                            deviceManager.remove(equipCode);
                            deviceManager.add(equipCode, (Object)ctx.channel());
                            channel.attr(CoreConst.CLIENT_OVERRIDE_CLOSED).set((Object)Boolean.TRUE);
                        }
                    } else {
                        deviceManager.remove(equipCode);
                        deviceManager.add(equipCode, (Object)ctx.channel());
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("\u5ba2\u6237\u7aef\u51b2\u7a81({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {}", (Object)component.getName(), (Object)messageHead.getEquipCode());
                    }
                } else {
                    deviceManager.add(equipCode, (Object)ctx.channel());
                }
                statusEvent = new StatusEvent((Object)equipCode, ClientStatus.online, (FrameworkComponent)component);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u5ba2\u6237\u7aef\u4e0a\u7ebf({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{component.getName(), equipCode, ctx.channel().remoteAddress()});
                }
            } else {
                this.logger.warn("\u5ba2\u6237\u7aef\u6ce8\u518c\u5931\u8d25({}) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{component.getName(), equipCode, ctx.channel().remoteAddress()});
            }
            // MONITOREXIT : socketServerComponent
            if (statusEvent != null) {
                try {
                    FrameworkManager.publishEvent((IotEvent)new StatusEvent((Object)equipCode, ClientStatus.online, (FrameworkComponent)component));
                }
                catch (Exception e) {
                    this.logger.error("\u4e8b\u4ef6\u53d1\u5e03\u5931\u8d25({}) {}", (Object)component.getName(), (Object)e.getCause());
                }
            }
        } else if (msg.getHead().getEquipCode() == null) {
            msg.getHead().setEquipCode(equipCode);
        }
        ctx.fireChannelRead((Object)msg);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        InetSocketAddress localAddress = (InetSocketAddress)channel.localAddress();
        SocketServerComponent component = (SocketServerComponent)FrameworkManager.getTcpComponent((Integer)localAddress.getPort());
        if (!component.isActivation(channel, (FrameworkComponent)component)) {
            channel.close();
        } else {
            ChannelManager deviceManager = (ChannelManager)component.getDeviceManager();
            deviceManager.add((Object)channel);
            channel.attr(CoreConst.CLIENT_ONLINE_TIME).set((Object)System.currentTimeMillis());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("\u5ba2\u6237\u7aef\u6fc0\u6d3b \u5ba2\u6237\u7aef\u5730\u5740\uff1a{}", (Object)channel.remoteAddress());
            }
            super.channelActive(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            InetSocketAddress remoteAddress;
            Attribute attribute = ctx.channel().attr(CoreConst.EQUIP_CODE);
            InetSocketAddress address = (InetSocketAddress)ctx.channel().localAddress();
            SocketServerComponent serverComponent = (SocketServerComponent)FrameworkManager.getTcpComponent((Integer)address.getPort());
            Object equipCode = attribute.get();
            if (equipCode != null && this.logger.isWarnEnabled()) {
                InetSocketAddress remoteAddress2 = (InetSocketAddress)ctx.channel().remoteAddress();
                Boolean aBoolean = (Boolean)ctx.channel().attr(CoreConst.CLIENT_OVERRIDE_CLOSED).get();
                if (Boolean.TRUE.equals(aBoolean)) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("\u5ba2\u6237\u7aef\u65ad\u7ebf({}) \u5ba2\u6237\u7aef\u5df2\u5b58\u5728 - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{serverComponent.getName(), equipCode, remoteAddress2});
                    }
                } else {
                    Long timeout = (Long)ctx.channel().attr(CoreConst.CLIENT_TIMEOUT_CLOSED).get();
                    StatusEvent clientStatusEvent = new StatusEvent(equipCode, ClientStatus.offline, (FrameworkComponent)serverComponent);
                    if (timeout != null) {
                        clientStatusEvent.setReason(OfflineReason.timeout);
                    }
                    FrameworkManager.publishEvent((IotEvent)clientStatusEvent);
                    if (this.logger.isWarnEnabled()) {
                        if (timeout != null) {
                            this.logger.warn("\u5ba2\u6237\u7aef\u65ad\u7ebf({}) \u8bfb\u5199\u8d85\u65f6({}s) - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{serverComponent.getName(), timeout, equipCode, remoteAddress2});
                        } else {
                            this.logger.warn("\u5ba2\u6237\u7aef\u65ad\u7ebf({}) \u8fde\u63a5\u5173\u95ed - \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u5ba2\u6237\u7aef\u5730\u5740: {}", new Object[]{serverComponent.getName(), equipCode, remoteAddress2});
                        }
                    }
                }
            } else if (this.logger.isWarnEnabled() && (remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress()) != null && serverComponent != null) {
                this.logger.warn("\u5ba2\u6237\u7aef\u65ad\u7ebf({}) \u5ba2\u6237\u7aef\u5f02\u5e38 - \u5ba2\u6237\u7aef\u7f16\u53f7: \u672a\u6ce8\u518c - \u5ba2\u6237\u7aef\u5730\u5740: {}", (Object)serverComponent.getName(), (Object)remoteAddress);
            }
        }
        finally {
            super.channelInactive(ctx);
        }
    }
}

