/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.endpoints;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.iteaj.iot.server.endpoints.Result;
import com.iteaj.iot.server.endpoints.ServerHealthBuilder;
import com.iteaj.iot.server.websocket.WebSocketServerListener;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerMessage;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerProtocol;
import java.util.Optional;

public class ServerHealthWebsocketEndpoint
implements WebSocketServerListener {
    private long startupDate;

    public ServerHealthWebsocketEndpoint(long startupDate) {
        this.startupDate = startupDate;
    }

    @Override
    public String uri() {
        return "/ws/endpoint/health";
    }

    @Override
    public void onText(DefaultWebSocketServerProtocol protocol) {
        String requestText = protocol.readText();
        Optional<String> type = ((DefaultWebSocketServerMessage)protocol.requestMessage()).getQueryParam("type");
        if (StrUtil.isNotBlank((CharSequence)requestText) && !type.isPresent()) {
            try {
                type = Optional.ofNullable(JSON.parseObject((String)requestText).getString("type"));
            }
            catch (Exception e) {
                protocol.response(Result.fail("\u8bf7\u6c42\u53c2\u6570\u53ea\u652f\u6301Json\u683c\u5f0f").textJson());
                return;
            }
        }
        if (type.isPresent()) {
            Result info;
            switch (type.get()) {
                case "jvm": {
                    info = Result.success(ServerHealthBuilder.buildJvmInfo());
                    break;
                }
                case "system": {
                    info = Result.success(ServerHealthBuilder.buildSystemInfo());
                    break;
                }
                case "server": {
                    info = Result.success(ServerHealthBuilder.buildComponentInfo());
                    break;
                }
                default: {
                    info = Result.fail("\u9519\u8bef\u7684\u53c2\u6570\u503c[" + type + "], \u53ef\u9009\u503c[jvm, system, server]");
                }
            }
            protocol.response(info.textJson());
        } else {
            Result result = ServerHealthBuilder.toResult(this.startupDate);
            protocol.response(result.textJson());
        }
    }

    @Override
    public void onClose(DefaultWebSocketServerProtocol protocol) {
    }

    @Override
    public void onBinary(DefaultWebSocketServerProtocol protocol) {
        protocol.response(Result.fail("\u4e0d\u652f\u6301\u4f7f\u7528\u4e8c\u8fdb\u5236\u8bf7\u6c42").binaryJson());
    }
}

