/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.endpoints;

import java.lang.management.MemoryUsage;
import java.util.List;

public class ServerHealthEntity {
    private long startTime;
    private long collectTime;
    private JvmInfo jvm;
    private SystemInfo system;
    private ComponentInfo server;

    public ServerHealthEntity(long startTime, SystemInfo system, JvmInfo jvm, ComponentInfo server) {
        this.jvm = jvm;
        this.system = system;
        this.server = server;
        this.startTime = startTime;
        this.collectTime = System.currentTimeMillis();
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public void setCollectTime(long collectTime) {
        this.collectTime = collectTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public SystemInfo getSystem() {
        return this.system;
    }

    public void setSystem(SystemInfo system) {
        this.system = system;
    }

    public JvmInfo getJvm() {
        return this.jvm;
    }

    public void setJvm(JvmInfo jvm) {
        this.jvm = jvm;
    }

    public ComponentInfo getServer() {
        return this.server;
    }

    public void setServer(ComponentInfo server) {
        this.server = server;
    }

    public static class Component {
        private int port;
        private String name;
        private String protocol;
        private long startTime;
        private long linkingCount;
        private long registerCount;

        public Component(int port, String name, String protocol, long startTime) {
            this(port, name, protocol, startTime, 0L, 0L);
        }

        public Component(int port, String name, String protocol, long startTime, long linkingCount, long registerCount) {
            this.port = port;
            this.name = name;
            this.protocol = protocol;
            this.startTime = startTime;
            this.linkingCount = linkingCount;
            this.registerCount = registerCount;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getLinkingCount() {
            return this.linkingCount;
        }

        public void setLinkingCount(long linkingCount) {
            this.linkingCount = linkingCount;
        }

        public long getRegisterCount() {
            return this.registerCount;
        }

        public void setRegisterCount(long registerCount) {
            this.registerCount = registerCount;
        }
    }

    public static class ComponentInfo {
        private List<Component> components;

        public ComponentInfo(List<Component> components) {
            this.components = components;
        }

        public List<Component> getComponents() {
            return this.components;
        }

        public void setComponents(List<Component> components) {
            this.components = components;
        }
    }

    public static class JvmInfo {
        private MemoryUsage heapMemory;
        private MemoryUsage nonHeapMemory;

        public JvmInfo(MemoryUsage heapMemory, MemoryUsage nonHeapMemory) {
            this.heapMemory = heapMemory;
            this.nonHeapMemory = nonHeapMemory;
        }

        public MemoryUsage getHeapMemory() {
            return this.heapMemory;
        }

        public void setHeapMemory(MemoryUsage heapMemory) {
            this.heapMemory = heapMemory;
        }

        public MemoryUsage getNonHeapMemory() {
            return this.nonHeapMemory;
        }

        public void setNonHeapMemory(MemoryUsage nonHeapMemory) {
            this.nonHeapMemory = nonHeapMemory;
        }
    }

    public static class SystemInfo {
        private String os;
        private String arch;
        private String version;
        private long processCpuTime;
        private double systemCpuLoad;
        private double processCpuLoad;
        private long freePMSize;
        private long totalPMSize;

        public String getOs() {
            return this.os;
        }

        public SystemInfo setOs(String os) {
            this.os = os;
            return this;
        }

        public String getArch() {
            return this.arch;
        }

        public SystemInfo setArch(String arch) {
            this.arch = arch;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public SystemInfo setVersion(String version) {
            this.version = version;
            return this;
        }

        public long getProcessCpuTime() {
            return this.processCpuTime;
        }

        public SystemInfo setProcessCpuTime(long processCpuTime) {
            this.processCpuTime = processCpuTime;
            return this;
        }

        public double getSystemCpuLoad() {
            return this.systemCpuLoad;
        }

        public SystemInfo setSystemCpuLoad(double systemCpuLoad) {
            this.systemCpuLoad = systemCpuLoad;
            return this;
        }

        public double getProcessCpuLoad() {
            return this.processCpuLoad;
        }

        public SystemInfo setProcessCpuLoad(double processCpuLoad) {
            this.processCpuLoad = processCpuLoad;
            return this;
        }

        public long getFreePMSize() {
            return this.freePMSize;
        }

        public SystemInfo setFreePMSize(long freePMSize) {
            this.freePMSize = freePMSize;
            return this;
        }

        public long getTotalPMSize() {
            return this.totalPMSize;
        }

        public SystemInfo setTotalPMSize(long totalPMSize) {
            this.totalPMSize = totalPMSize;
            return this;
        }
    }
}

