/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu.impl;

import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.message.DefaultMessageHead;
import com.iteaj.iot.server.dtu.DtuCommonProtocolType;
import com.iteaj.iot.server.dtu.impl.CommonDtuServerMessage;
import com.iteaj.iot.server.protocol.ServerInitiativeSyncProtocol;
import java.io.IOException;

public class CommonDtuProtocol
extends ServerInitiativeSyncProtocol<CommonDtuServerMessage> {
    private String deviceSn;
    private byte[] message;

    public CommonDtuProtocol(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public byte[] read(byte[] cmd) {
        this.message = cmd;
        this.request();
        if (this.getExecStatus() == ExecStatus.success) {
            return ((CommonDtuServerMessage)this.responseMessage()).getMessage();
        }
        return null;
    }

    public ExecStatus writeOfAsync(byte[] cmd) {
        this.message = cmd;
        this.setDownLatch(null);
        this.request();
        return this.getExecStatus();
    }

    public byte[] write(byte[] cmd) {
        this.message = cmd;
        this.request();
        if (this.getExecStatus() == ExecStatus.success) {
            return ((CommonDtuServerMessage)this.responseMessage()).getMessage();
        }
        return null;
    }

    @Override
    public CommonDtuProtocol sync(long timeout) {
        return (CommonDtuProtocol)((Object)super.sync(timeout));
    }

    @Override
    public CommonDtuProtocol timeout(long timeout) {
        return (CommonDtuProtocol)super.timeout(timeout);
    }

    @Override
    protected CommonDtuServerMessage doBuildRequestMessage() throws IOException {
        DefaultMessageHead messageHead = new DefaultMessageHead(this.deviceSn, this.deviceSn, this.protocolType());
        messageHead.setMessage(this.getMessage());
        return new CommonDtuServerMessage((Message.MessageHead)messageHead);
    }

    @Override
    protected void doBuildResponseMessage(CommonDtuServerMessage message) {
    }

    public boolean isRelation() {
        if (this.isSyncRequest()) {
            return super.isRelation();
        }
        return false;
    }

    @Override
    public ProtocolType protocolType() {
        return DtuCommonProtocolType.COMMON;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public void setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }
}

