/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.IotProtocolFactory;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.server.IotSocketServer;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.dtu.DtuCommonProtocolType;
import com.iteaj.iot.server.dtu.DtuMessageAware;
import com.iteaj.iot.server.dtu.DtuMessageType;
import com.iteaj.iot.server.dtu.message.DtuMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public interface DtuMessageDecoder<M extends ServerMessage>
extends SocketMessageDecoder<ByteBuf>,
IotProtocolFactory<M>,
IotSocketServer,
DtuMessageAware<M> {
    public DtuMessageAware<M> getDtuMessageAwareDelegation();

    @Override
    default public DtuMessageType messageType() {
        return this.getDtuMessageAwareDelegation().messageType();
    }

    @Override
    default public String resolveEquipCode(byte[] equipMessage) {
        return this.getDtuMessageAwareDelegation().resolveEquipCode(equipMessage);
    }

    @Override
    default public String resolveHeartbeat(byte[] message) {
        return this.getDtuMessageAwareDelegation().resolveHeartbeat(message);
    }

    @Override
    default public AbstractProtocol customize(M message, IotProtocolFactory<M> factory) {
        return this.getDtuMessageAwareDelegation().customize(message, factory);
    }

    @Override
    default public M decodeBefore(String equipCode, byte[] message, ByteBuf msg) {
        return this.getDtuMessageAwareDelegation().decodeBefore(equipCode, message, msg);
    }

    default public M createMessage(byte[] message) {
        SocketMessage serverMessage = super.createMessage(message);
        if (serverMessage instanceof DtuMessage) {
            return (M)((ServerMessage)serverMessage);
        }
        throw new ProtocolException("Dtu\u62a5\u6587\u5bf9\u8c61\u5fc5\u987b\u662f[" + DtuMessage.class.getSimpleName() + "]\u7684\u5b50\u7c7b");
    }

    default public M buildDeviceSnMessage(ChannelHandlerContext ctx, ByteBuf buf) {
        byte[] message = new byte[buf.readableBytes()];
        buf.readBytes(message);
        String deviceSn = this.resolveEquipCode(message);
        M dtuMessage = this.createMessage(message);
        ((DtuMessage)dtuMessage).setEquipCode(deviceSn);
        ((DtuMessage)dtuMessage).setProtocolType(DtuCommonProtocolType.DEVICE_SN);
        return dtuMessage;
    }

    public Class<M> getMessageClass();

    default public M doTcpDecode(ChannelHandlerContext ctx, ByteBuf in) {
        SocketMessage decode = super.doTcpDecode(ctx, in);
        Object equipCode = ctx.channel().attr(CoreConst.EQUIP_CODE).get();
        if (equipCode != null) {
            ((DtuMessage)decode).setEquipCode((String)equipCode);
        }
        return (M)((ServerMessage)decode);
    }

    default public AbstractProtocol getProtocol(M message) {
        AbstractProtocol protocol = this.customize(message, this);
        if (protocol != null) {
            return protocol;
        }
        return this.doGetProtocol(message);
    }

    public AbstractProtocol doGetProtocol(M var1);
}

