/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.IotProtocolFactory;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.dtu.DtuMessageType;
import com.iteaj.iot.utils.ByteUtil;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public interface DtuMessageAware<M extends ServerMessage> {
    public static final String AT_OK_END = "OK\r\n";
    public static final String AT_ERROR_END = "ERROR\r\n";

    default public DtuMessageType messageType() {
        return DtuMessageType.ASCII;
    }

    default public String resolveHeartbeat(byte[] message) {
        if (this.messageType() == DtuMessageType.ASCII) {
            return new String(message, StandardCharsets.US_ASCII);
        }
        return ByteUtil.bytesToHex((byte[])message);
    }

    default public String resolveEquipCode(byte[] equipMessage) {
        if (this.messageType() == DtuMessageType.ASCII) {
            return new String(equipMessage, StandardCharsets.US_ASCII);
        }
        return ByteUtil.bytesToHex((byte[])equipMessage);
    }

    public AbstractProtocol customize(M var1, IotProtocolFactory<M> var2);

    public M decodeBefore(String var1, byte[] var2, ByteBuf var3);
}

