/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu;

import com.iteaj.iot.CoreConst;
import com.iteaj.iot.server.dtu.DtuCommonProtocolType;
import com.iteaj.iot.server.dtu.DtuMessageDecoder;
import com.iteaj.iot.server.dtu.message.DtuMessage;
import com.iteaj.iot.server.dtu.message.DtuPassMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;

public class DtuFirstDeviceSnPackageHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private DtuMessageDecoder messageDecoder;

    public DtuFirstDeviceSnPackageHandler(DtuMessageDecoder messageDecoder) {
        super(false);
        this.messageDecoder = messageDecoder;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        Attribute attr = ctx.channel().attr(CoreConst.EQUIP_CODE);
        if (attr.get() == null) {
            this.buildDeviceSnMessage(ctx, buf);
        } else {
            byte[] message = new byte[buf.readableBytes()];
            buf.slice().readBytes(message);
            Object serverMessage = this.messageDecoder.decodeBefore((String)attr.get(), message, buf);
            if (serverMessage != null) {
                if (serverMessage instanceof DtuPassMessage) {
                    ctx.fireChannelRead((Object)buf);
                } else {
                    serverMessage.setChannelId(ctx.channel().id().asShortText());
                    ctx.fireChannelRead((Object)serverMessage.readBuild());
                }
            } else {
                return;
            }
        }
    }

    private void buildDeviceSnMessage(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        byte[] message = new byte[buf.readableBytes()];
        buf.readBytes(message).release();
        String deviceSn = this.messageDecoder.resolveEquipCode(message);
        Object dtuMessage = this.messageDecoder.createMessage(message);
        ((DtuMessage)dtuMessage).setEquipCode(deviceSn);
        ((DtuMessage)dtuMessage).setProtocolType(DtuCommonProtocolType.DEVICE_SN);
        ctx.fireChannelRead((Object)dtuMessage.readBuild());
    }
}

