/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.component.ByteToMessageDecoderServerComponent;
import com.iteaj.iot.server.dtu.DefaultDtuMessageAware;
import com.iteaj.iot.server.dtu.DtuMessageAware;
import com.iteaj.iot.server.dtu.DtuMessageDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;

public abstract class DtuDecoderServerComponent<M extends ServerMessage>
extends ByteToMessageDecoderServerComponent<M>
implements DtuMessageDecoder<M> {
    private DtuMessageAware<M> dtuMessageAwareDelegation;

    public DtuDecoderServerComponent(ConnectProperties connectProperties) {
        super(connectProperties);
        this.dtuMessageAwareDelegation = new DefaultDtuMessageAware(this);
    }

    public DtuDecoderServerComponent(ConnectProperties connectProperties, DtuMessageAware<M> dtuMessageAwareDelegation) {
        super(connectProperties);
        this.setDtuMessageAwareDelegation(dtuMessageAwareDelegation);
    }

    @Override
    public AbstractProtocol getProtocol(M message) {
        return DtuMessageDecoder.super.getProtocol(message);
    }

    @Override
    public M doTcpDecode(ChannelHandlerContext ctx, ByteBuf buf) {
        Attribute attr = ctx.channel().attr(CoreConst.EQUIP_CODE);
        if (attr.get() == null) {
            return (M)this.buildDeviceSnMessage(ctx, buf);
        }
        byte[] message = new byte[buf.readableBytes()];
        buf.slice().readBytes(message);
        M serverMessage = this.getDtuMessageAwareDelegation().decodeBefore((String)attr.get(), message, buf);
        if (serverMessage != null) {
            serverMessage.setChannelId(ctx.channel().id().asShortText());
            return (M)serverMessage.readBuild();
        }
        return null;
    }

    @Override
    public DtuMessageAware<M> getDtuMessageAwareDelegation() {
        return this.dtuMessageAwareDelegation;
    }

    public void setDtuMessageAwareDelegation(DtuMessageAware<M> dtuMessageAwareDelegation) {
        this.dtuMessageAwareDelegation = dtuMessageAwareDelegation;
        if (this.dtuMessageAwareDelegation instanceof DefaultDtuMessageAware && ((DefaultDtuMessageAware)this.dtuMessageAwareDelegation).getDecoder() == null) {
            ((DefaultDtuMessageAware)this.dtuMessageAwareDelegation).setDecoder(this);
        }
    }
}

