/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.dtu;

import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.IotProtocolFactory;
import com.iteaj.iot.message.DefaultMessageHead;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.dtu.DtuCommonProtocolType;
import com.iteaj.iot.server.dtu.DtuMessageAware;
import com.iteaj.iot.server.dtu.DtuMessageDecoder;
import com.iteaj.iot.server.dtu.DtuMessageType;
import com.iteaj.iot.server.dtu.message.DtuMessage;
import com.iteaj.iot.server.dtu.protocol.DtuDeviceSnProtocol;
import com.iteaj.iot.server.dtu.protocol.DtuHeartbeatProtocol;
import com.iteaj.iot.server.dtu.protocol.DtuPrivateProtocol;
import com.iteaj.iot.utils.ByteUtil;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class DefaultDtuMessageAware<M extends ServerMessage>
implements DtuMessageAware<M> {
    private String atOkEnd;
    private String atErrorEnd;
    private DtuMessageType messageType;
    private DtuMessageDecoder<M> decoder;

    public DefaultDtuMessageAware() {
        this(DtuMessageType.ASCII);
    }

    public DefaultDtuMessageAware(DtuMessageDecoder decoder) {
        this(DtuMessageType.ASCII);
        this.decoder = decoder;
    }

    public DefaultDtuMessageAware(DtuMessageType messageType) {
        this.messageType = messageType;
        this.atOkEnd = "OK\r\n";
        this.atErrorEnd = "ERROR\r\n";
    }

    public DtuMessageAware buildAT(String atOkEnd, String atErrorEnd) {
        this.atOkEnd = atOkEnd;
        this.atErrorEnd = atErrorEnd;
        return this;
    }

    @Override
    public DtuMessageType messageType() {
        return this.messageType;
    }

    @Override
    public AbstractProtocol customize(M message, IotProtocolFactory<M> factory) {
        DefaultMessageHead head = (DefaultMessageHead)message.getHead();
        if (head != null) {
            if (head.getType() == DtuCommonProtocolType.DEVICE_SN) {
                return this.getDeviceSnRegisterProtocol(message);
            }
            if (head.getType() == DtuCommonProtocolType.HEARTBEAT) {
                return this.getHeartbeatProtocol(message);
            }
            if (head.getType() == DtuCommonProtocolType.AT) {
                return (AbstractProtocol)factory.remove((Object)head.getMessageId());
            }
            if (head.getType() == DtuCommonProtocolType.DTU) {
                return this.getDtuPrivateProtocol(message);
            }
        }
        return null;
    }

    private AbstractProtocol getDtuPrivateProtocol(M message) {
        return new DtuPrivateProtocol((ServerMessage)message);
    }

    protected AbstractProtocol getDeviceSnRegisterProtocol(M message) {
        return new DtuDeviceSnProtocol((ServerMessage)message);
    }

    protected AbstractProtocol getHeartbeatProtocol(M message) {
        return new DtuHeartbeatProtocol((ServerMessage)message);
    }

    protected int heartbeatLength(String equipCode) {
        DtuMessageType messageType = this.getDecoder().messageType();
        if (messageType == DtuMessageType.ASCII) {
            return equipCode.getBytes(StandardCharsets.US_ASCII).length;
        }
        return ByteUtil.hexToByte((String)equipCode).length;
    }

    @Override
    public M decodeBefore(String equipCode, byte[] message, ByteBuf msg) {
        String strMsg = this.getDecoder().resolveHeartbeat(message);
        if (strMsg.startsWith(equipCode)) {
            message = new byte[this.heartbeatLength(equipCode)];
            msg.readBytes(message);
            M heartMessage = this.createMessage(message);
            if (heartMessage instanceof DtuMessage) {
                ((DtuMessage)heartMessage).setEquipCode(equipCode);
                ((DtuMessage)heartMessage).setProtocolType(DtuCommonProtocolType.HEARTBEAT);
            }
            return heartMessage;
        }
        byte[] msgBytes = this.readAtMsg(equipCode, message, msg);
        if (msgBytes != null) {
            M atMessage = this.createMessage(msgBytes);
            ((DtuMessage)atMessage).setEquipCode(equipCode);
            ((DtuMessage)atMessage).setProtocolType(DtuCommonProtocolType.AT);
            return atMessage;
        }
        msgBytes = this.readDtuMsg(equipCode, message, msg);
        if (msgBytes != null) {
            M dtuMessage = this.createMessage(msgBytes);
            ((DtuMessage)dtuMessage).setEquipCode(equipCode);
            ((DtuMessage)dtuMessage).setProtocolType(DtuCommonProtocolType.DTU);
            return dtuMessage;
        }
        M customizeMessage = this.customizeType(equipCode, message, msg);
        if (customizeMessage != null) {
            if (((DtuMessage)customizeMessage).getEquipCode() == null) {
                ((DtuMessage)customizeMessage).setEquipCode(equipCode);
            }
            return customizeMessage;
        }
        return null;
    }

    protected M createMessage(byte[] message) {
        return this.getDecoder().createMessage(message);
    }

    protected M createMessage(int length, ByteBuf msg) {
        byte[] message = new byte[length];
        msg.readBytes(message);
        return this.createMessage(message);
    }

    protected M createMessage(DtuCommonProtocolType type, ByteBuf msg) {
        byte[] message = new byte[msg.readableBytes()];
        msg.readBytes(message);
        return (M)((ServerMessage)((DtuMessage)this.createMessage(message)).setProtocolType(type));
    }

    protected byte[] readAtMsg(String equipCode, byte[] message, ByteBuf msg) {
        String atMsg;
        int indexOf;
        if (this.getAtOkEnd() != null && (indexOf = (atMsg = new String(message)).indexOf(this.getAtOkEnd())) > 0) {
            message = new byte[indexOf + this.getAtOkEnd().length()];
            msg.readBytes(message);
            return message;
        }
        if (this.getAtErrorEnd() != null && (indexOf = (atMsg = new String(message)).indexOf(this.getAtErrorEnd())) > 0) {
            message = new byte[indexOf + this.getAtErrorEnd().length()];
            msg.readBytes(message);
            return message;
        }
        return null;
    }

    protected byte[] readDtuMsg(String equipCode, byte[] message, ByteBuf msg) {
        return null;
    }

    protected M customizeType(String equipCode, byte[] message, ByteBuf msg) {
        message = new byte[msg.readableBytes()];
        msg.readBytes(message);
        return this.createMessage(message);
    }

    public DtuMessageDecoder<M> getDecoder() {
        return this.decoder;
    }

    public void setDecoder(DtuMessageDecoder<M> decoder) {
        this.decoder = decoder;
    }

    public String getAtOkEnd() {
        return this.atOkEnd;
    }

    public String getAtErrorEnd() {
        return this.atErrorEnd;
    }

    public void setMessageType(DtuMessageType messageType) {
        this.messageType = messageType;
    }
}

