/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.component;

import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.codec.adapter.LengthFieldBasedFrameMessageDecoderAdapter;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.component.TcpDecoderServerComponent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.ByteOrder;
import java.util.List;

public abstract class LengthFieldBasedFrameDecoderServerComponent<M extends ServerMessage>
extends TcpDecoderServerComponent<M> {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;

    public LengthFieldBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength) {
        this(connectProperties, maxFrameLength, lengthFieldOffset, lengthFieldLength, 0, 0);
    }

    public LengthFieldBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        this(connectProperties, maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, true);
    }

    public LengthFieldBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        this(connectProperties, ByteOrder.BIG_ENDIAN, maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, failFast);
    }

    public LengthFieldBasedFrameDecoderServerComponent(ConnectProperties connectProperties, ByteOrder byteOrder, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        super(connectProperties);
        this.failFast = failFast;
        this.byteOrder = byteOrder;
        this.maxFrameLength = maxFrameLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
    }

    public ChannelInboundHandlerAdapter getMessageDecoder() {
        return new LengthFieldBasedFrameMessageDecoderAdapter(this.byteOrder, this.maxFrameLength, this.lengthFieldOffset, this.lengthFieldLength, this.lengthAdjustment, this.initialBytesToStrip, this.failFast){

            public Class<? extends SocketMessage> getMessageClass() {
                return LengthFieldBasedFrameDecoderServerComponent.this.getMessageClass();
            }
        };
    }

    public List<M> decodes(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5, \u8bf7\u4f7f\u7528\u65b9\u6cd5\uff1aDeviceMessageDecoder.decode(ctx, in)");
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public int getLengthFieldOffset() {
        return this.lengthFieldOffset;
    }

    public int getLengthFieldLength() {
        return this.lengthFieldLength;
    }

    public int getLengthAdjustment() {
        return this.lengthAdjustment;
    }

    public int getInitialBytesToStrip() {
        return this.initialBytesToStrip;
    }

    public boolean isFailFast() {
        return this.failFast;
    }
}

