/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.component;

import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.codec.adapter.DelimiterBasedFrameMessageDecoderAdapter;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.component.TcpDecoderServerComponent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.List;

public abstract class DelimiterBasedFrameDecoderServerComponent<M extends ServerMessage>
extends TcpDecoderServerComponent<M> {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;

    public DelimiterBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, ByteBuf delimiter) {
        this(connectProperties, maxFrameLength, true, delimiter);
    }

    public DelimiterBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, boolean stripDelimiter, ByteBuf delimiter) {
        this(connectProperties, maxFrameLength, stripDelimiter, true, delimiter);
    }

    public DelimiterBasedFrameDecoderServerComponent(ConnectProperties connectProperties, int maxFrameLength, boolean stripDelimiter, boolean failFast, ByteBuf delimiter) {
        super(connectProperties);
        this.maxFrameLength = maxFrameLength;
        this.delimiters = new ByteBuf[]{delimiter};
        this.stripDelimiter = stripDelimiter;
        this.failFast = failFast;
    }

    public ChannelInboundHandlerAdapter getMessageDecoder() {
        return new DelimiterBasedFrameMessageDecoderAdapter(this.maxFrameLength, this.stripDelimiter, this.failFast, this.delimiters).setDelegation((SocketMessageDecoder)this);
    }

    public List<M> decodes(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5, \u8bf7\u4f7f\u7528\u65b9\u6cd5\uff1aDeviceMessageDecoder.decode(ctx, in)");
    }
}

