/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.codec;

import com.iteaj.iot.CoreConst;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.codec.adapter.SocketMessageDecoderDelegation;
import com.iteaj.iot.server.websocket.WebSocketServerComponent;
import com.iteaj.iot.server.websocket.WebSocketServerComponentAbstract;
import com.iteaj.iot.websocket.HttpRequestWrapper;
import com.iteaj.iot.websocket.WebSocketFrameType;
import com.iteaj.iot.websocket.WebSocketInterceptor;
import com.iteaj.iot.websocket.WebSocketServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketServerDecoder
extends SimpleChannelInboundHandler<Object>
implements SocketMessageDecoderDelegation<ReferenceCounted> {
    private SocketMessageDecoder delegation;
    private WebSocketServerComponentAbstract component;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public WebSocketServerDecoder(WebSocketServerComponentAbstract component) {
        super(false);
        this.component = component;
    }

    public SocketMessageDecoder<ReferenceCounted> getDelegation() {
        return this.delegation;
    }

    public SocketMessageDecoderDelegation setDelegation(SocketMessageDecoder<ReferenceCounted> delegation) {
        this.delegation = delegation;
        return this;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public SocketMessage readBuild(SocketMessage message) {
        return message;
    }

    private ChannelFuture handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        SocketMessage socketMessage;
        if (frame instanceof PingWebSocketFrame) {
            return this.ping(ctx, frame);
        }
        if (frame.isFinalFragment() && (socketMessage = this.proxy(ctx, (ReferenceCounted)frame.content())) instanceof WebSocketServerMessage) {
            HttpRequestWrapper wrapper = (HttpRequestWrapper)ctx.channel().attr(CoreConst.WEBSOCKET_REQ).get();
            ((WebSocketServerMessage)socketMessage).setRequest(wrapper);
            if (frame instanceof TextWebSocketFrame) {
                ((WebSocketServerMessage)socketMessage).setFrameType(WebSocketFrameType.Text);
            } else if (frame instanceof BinaryWebSocketFrame) {
                ((WebSocketServerMessage)socketMessage).setFrameType(WebSocketFrameType.Binary);
            } else if (frame instanceof CloseWebSocketFrame) {
                ctx.close();
                if (this.logger.isDebugEnabled()) {
                    HttpRequestWrapper request = wrapper;
                    this.logger.debug("\u62a5\u6587\u89e3\u7801({}) \u6536\u5230Close\u8bf7\u6c42 - uri\uff1a{}", (Object)this.component.getName(), (Object)request.getUri());
                }
                ((WebSocketServerMessage)socketMessage).setFrameType(WebSocketFrameType.Close);
            }
            ctx.fireChannelRead((Object)socketMessage.readBuild());
        }
        return null;
    }

    protected ChannelFuture close(ChannelHandlerContext ctx, WebSocketFrame frame) {
        return ctx.channel().writeAndFlush((Object)frame.retain()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected ChannelFuture ping(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (this.logger.isDebugEnabled()) {
            HttpRequestWrapper request = (HttpRequestWrapper)ctx.channel().attr(CoreConst.WEBSOCKET_REQ).get();
            this.logger.debug("\u62a5\u6587\u89e3\u7801({}) \u6536\u5230ping\u8bf7\u6c42 - uri\uff1a{}", (Object)this.component.getName(), (Object)request.getUri());
        }
        return ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        block6: {
            WebSocketInterceptor filter = this.component.getInterceptor();
            if (!filter.handShaker(ctx.channel(), req)) {
                this.logger.warn("\u62a5\u6587\u89e3\u7801({}) Http Upgrade\u5931\u8d25 - uri\uff1a{} - Upgrade\uff1a{}", new Object[]{this.component.getName(), req.uri(), req.headers().get("Upgrade"), req.decoderResult().cause()});
                return;
            }
            try {
                if (this.delegation instanceof WebSocketServerComponent) {
                    WebSocketServerHandshaker handShaker = ((WebSocketServerComponent)this.delegation).createServerHandShaker(ctx, req);
                    if (handShaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                    } else {
                        handShaker.handshake(ctx.channel(), req).addListener(future -> {
                            if (future.isSuccess()) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("\u62a5\u6587\u89e3\u7801({}) \u63e1\u624b\u6210\u529f - uri\uff1a{}", (Object)this.component.getName(), (Object)req.uri());
                                }
                            } else {
                                this.logger.debug("\u62a5\u6587\u89e3\u7801({}) \u63e1\u624b\u5931\u8d25 - uri\uff1a{}", new Object[]{this.component.getName(), req.uri(), future.cause()});
                            }
                        });
                        ctx.channel().attr(CoreConst.WEBSOCKET_REQ).set((Object)new HttpRequestWrapper(req, handShaker.version()));
                    }
                    break block6;
                }
                throw new WebSocketHandshakeException("\u521b\u5efaWebSocketHandshake\u5931\u8d25");
            }
            catch (Exception e) {
                WebSocketServerDecoder.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, DefaultFullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

