/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.codec;

import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolPreservable;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.event.ExceptionEvent;
import com.iteaj.iot.event.IotEvent;
import com.iteaj.iot.server.ServerSocketProtocol;
import com.iteaj.iot.server.codec.DeviceProtocolEncoder;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import com.iteaj.iot.server.udp.UdpServerComponent;
import com.iteaj.iot.server.udp.UdpServerMessage;
import com.iteaj.iot.udp.UdpMessageHead;
import com.iteaj.iot.udp.UdpProtocolException;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class UdpServerProtocolEncoder
extends ChannelOutboundHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(DeviceProtocolEncoder.class);
    private static UdpServerProtocolEncoder udpServerProtocolEncoder = new UdpServerProtocolEncoder();

    public static UdpServerProtocolEncoder getInstance() {
        return udpServerProtocolEncoder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        UdpServerMessage message = null;
        try {
            if (msg instanceof ServerSocketProtocol) {
                DatagramPacket packet;
                ServerSocketProtocol protocol = (ServerSocketProtocol)msg;
                if (protocol instanceof ProtocolPreservable) {
                    message = this.doBuild((SocketMessage)protocol.requestMessage(), "\u5e73\u53f0\u8bf7\u6c42\u5ba2\u6237\u7aef");
                    packet = new DatagramPacket(Unpooled.wrappedBuffer((byte[])message.getMessage()), message.getRecipient(), message.getSender());
                    if (((ProtocolPreservable)protocol).isRelation()) {
                        long timeout = ((ProtocolPreservable)protocol).getTimeout();
                        UdpServerComponent serverComponent = (UdpServerComponent)FrameworkManager.getServerComponent(((Object)((Object)message)).getClass());
                        serverComponent.protocolFactory().add((String)((ProtocolPreservable)protocol).relationKey(), (Protocol)protocol, timeout);
                    }
                } else if (protocol instanceof ClientInitiativeProtocol) {
                    message = this.doBuild((SocketMessage)protocol.responseMessage(), "\u5e73\u53f0\u54cd\u5e94\u5ba2\u6237\u7aef");
                    packet = new DatagramPacket(Unpooled.wrappedBuffer((byte[])message.getMessage()), message.getRecipient(), message.getSender());
                } else {
                    throw new UdpProtocolException("\u4e0d\u652f\u6301\u7684\u534f\u8bae");
                }
                ctx.write((Object)packet, promise);
            } else if (msg instanceof UdpServerMessage) {
                message = this.doBuild((SocketMessage)msg, "\u5e73\u53f0\u8bf7\u6c42\u5ba2\u6237\u7aef");
                DatagramPacket packet = new DatagramPacket(Unpooled.wrappedBuffer((byte[])message.getMessage()), message.getRecipient(), message.getSender());
                ctx.write((Object)packet, promise);
            } else {
                ctx.write(msg, promise);
            }
        }
        catch (Exception e) {
            if (message != null) {
                UdpMessageHead head = message.getHead();
                this.logger.error("UDP\u670d\u52a1\u7aef\u7f16\u7801 \u7f16\u7801\u5f02\u5e38 - \u63a5\u6536\u65b9\uff1a{} - \u534f\u8bae\u7c7b\u578b\uff1a{} - \u5df2\u53d1\u9001\u5f02\u5e38\u4e8b\u4ef6[ExceptionEvent]", new Object[]{message.getRecipient(), head != null ? head.getType() : "", e});
            } else {
                this.logger.error("UDP\u670d\u52a1\u7aef\u7f16\u7801 \u7f16\u7801\u5f02\u5e38 - \u5df2\u53d1\u9001\u5f02\u5e38\u4e8b\u4ef6[ExceptionEvent]", (Throwable)e);
            }
            if (e instanceof ProtocolException) {
                ((ProtocolException)e).setProtocol(msg);
                FrameworkManager.publishEvent((IotEvent)new ExceptionEvent((Throwable)e, null));
            }
            UdpProtocolException exception = new UdpProtocolException("\u7f16\u7801\u5931\u8d25", (Throwable)e, msg);
            FrameworkManager.publishEvent((IotEvent)new ExceptionEvent((Throwable)exception, null));
        }
    }

    protected UdpServerMessage doBuild(SocketMessage message, String desc) throws IOException {
        if (message.getMessage() == null) {
            message.writeBuild();
        }
        if (this.logger.isTraceEnabled()) {
            Message.MessageHead head = message.getHead();
            this.logger.trace("\u5e73\u53f0\u62a5\u6587\u7f16\u7801 {} - \u8bbe\u5907\u7f16\u53f7\uff1a{} - messageId: {}, \u62a5\u6587: {}", new Object[]{desc, head.getEquipCode(), head.getMessageId(), message});
        }
        return (UdpServerMessage)message;
    }
}

