/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server.codec;

import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.Message;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolPreservable;
import com.iteaj.iot.SocketMessage;
import com.iteaj.iot.event.ExceptionEvent;
import com.iteaj.iot.event.IotEvent;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.ServerSocketProtocol;
import com.iteaj.iot.server.TcpServerComponent;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DeviceProtocolEncoder
extends MessageToMessageEncoder<ServerSocketProtocol> {
    private Logger logger = LoggerFactory.getLogger(DeviceProtocolEncoder.class);
    private static DeviceProtocolEncoder deviceProtocolEncoder = new DeviceProtocolEncoder();

    protected DeviceProtocolEncoder() {
    }

    public static DeviceProtocolEncoder getInstance() {
        return deviceProtocolEncoder;
    }

    protected void encode(ChannelHandlerContext ctx, ServerSocketProtocol protocol, List<Object> out) throws Exception {
        try {
            TcpServerComponent serverComponent = (TcpServerComponent)((Object)ctx.channel().attr(CoreConst.COMPONENT).get());
            if (protocol instanceof ProtocolPreservable) {
                ServerMessage requestMessage = protocol.requestMessage();
                SocketMessage message = this.doBuild((SocketMessage)requestMessage, "\u5e73\u53f0\u8bf7\u6c42\u5ba2\u6237\u7aef", serverComponent);
                if (((ProtocolPreservable)protocol).isRelation()) {
                    long timeout = ((ProtocolPreservable)protocol).getTimeout();
                    serverComponent.protocolFactory().add((String)((ProtocolPreservable)protocol).relationKey(), (Protocol)protocol, timeout);
                }
                out.add(Unpooled.wrappedBuffer((byte[])message.getMessage()));
            } else if (protocol instanceof ClientInitiativeProtocol) {
                SocketMessage message = this.doBuild((SocketMessage)protocol.responseMessage(), "\u5e73\u53f0\u54cd\u5e94\u5ba2\u6237\u7aef", serverComponent);
                out.add(Unpooled.wrappedBuffer((byte[])message.getMessage()));
            } else {
                this.logger.error("\u5e73\u53f0\u62a5\u6587\u7f16\u7801({}) \u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b", (Object)serverComponent.getName(), (Object)new ProtocolException("\u4e0d\u652f\u6301\u7684\u534f\u8bae"));
            }
        }
        catch (Exception exception) {
            this.logger.error("\u5e73\u53f0\u62a5\u6587\u7f16\u7801 \u7f16\u7801\u5f02\u5e38({}) - \u8bbe\u5907\u7f16\u53f7\uff1a{} - \u534f\u8bae\u7c7b\u578b\uff1a{} - \u5df2\u53d1\u9001\u5f02\u5e38\u4e8b\u4ef6[ExceptionEvent]", new Object[]{exception.getCause(), protocol.getEquipCode(), protocol.protocolType(), exception});
            FrameworkManager.publishEvent((IotEvent)new ExceptionEvent((Throwable)exception, protocol.getEquipCode()));
        }
    }

    protected SocketMessage doBuild(SocketMessage message, String desc, TcpServerComponent serverComponent) throws IOException {
        if (message.getMessage() == null) {
            message.writeBuild();
        }
        if (this.logger.isTraceEnabled()) {
            Message.MessageHead head = message.getHead();
            this.logger.trace("{}({}) \u5ba2\u6237\u7aef\u7f16\u53f7: {} - \u534f\u8bae\u7c7b\u578b: {} - messageId: {} - \u62a5\u6587: {}", new Object[]{desc, serverComponent.getName(), head.getEquipCode(), head.getType(), head.getMessageId(), message});
        }
        return message;
    }
}

