/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server;

import com.iteaj.iot.ChannelManager;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkManager;
import com.iteaj.iot.IotThreadManager;
import com.iteaj.iot.PortType;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.codec.adapter.SocketMessageDecoderDelegation;
import com.iteaj.iot.codec.filter.CombinedInterceptor;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.ServerComponent;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.SocketServerComponent;
import com.iteaj.iot.server.codec.DeviceProtocolEncoder;
import com.iteaj.iot.server.handle.EventManagerHandler;
import com.iteaj.iot.server.handle.ProtocolBusinessHandler;
import com.iteaj.iot.server.manager.TcpDeviceManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public abstract class TcpServerComponent<M extends ServerMessage>
extends SocketServerComponent<M, ByteBuf> {
    public TcpServerComponent(ConnectProperties connectProperties) {
        super(connectProperties);
    }

    public TcpServerComponent(ConnectProperties connectProperties, CombinedInterceptor filter) {
        super(connectProperties, filter);
    }

    public TcpDeviceManager getDeviceManager() {
        return (TcpDeviceManager)super.getDeviceManager();
    }

    protected ServerBootstrap initParentChannel() {
        IotThreadManager threadManager = IotThreadManager.instance();
        return this.configOptions((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(threadManager.getBossGroup(), threadManager.getWorkerGroup()).handler((ChannelHandler)new LoggingHandler(threadManager.getProperties().getLevel()))).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.channel().attr(CoreConst.COMPONENT).set((Object)TcpServerComponent.this);
                TcpServerComponent.this.doInitChildChannel(p);
            }
        });
    }

    protected ServerBootstrap configOptions(ServerBootstrap bootstrap) {
        return bootstrap;
    }

    protected void doInitChildChannel(ChannelPipeline p) {
        TcpServerComponent serverComponent = this;
        p.addFirst("ServerProtocolEncoder", (ChannelHandler)DeviceProtocolEncoder.getInstance());
        ChannelInboundHandlerAdapter decoder = serverComponent.getMessageDecoder();
        if (decoder == null) {
            throw new ProtocolException("\u672a\u6307\u5b9a\u8bbe\u5907\u62a5\u6587\u89e3\u7801\u5668\uff1a" + serverComponent.getName());
        }
        if (decoder instanceof SocketMessageDecoderDelegation && ((SocketMessageDecoderDelegation)decoder).getDelegation() == null) {
            ((SocketMessageDecoderDelegation)decoder).setDelegation((SocketMessageDecoder)serverComponent);
        }
        p.addFirst("ServerProtocolDecoder", (ChannelHandler)decoder);
        ConnectProperties config = serverComponent.config();
        if (config.getReaderIdleTime() > 0L || config.getAllIdleTime() > 0L || config.getWriterIdleTime() > 0L) {
            p.addLast("IdleStateEventHandler", (ChannelHandler)new IdleStateHandler(config.getReaderIdleTime(), config.getWriterIdleTime(), config.getAllIdleTime(), TimeUnit.SECONDS));
        }
        EventManagerHandler instance = EventManagerHandler.getInstance();
        if (p.get("IdleStateEventHandler") != null) {
            p.addAfter("IdleStateEventHandler", "EventManagerHandler", (ChannelHandler)instance);
        } else {
            p.addLast("EventManagerHandler", (ChannelHandler)instance);
        }
        p.addLast("ServerServiceHandler", (ChannelHandler)ProtocolBusinessHandler.getInstance());
        serverComponent.doInitChannel(p);
    }

    protected ChannelManager createDeviceManager() {
        return (ChannelManager)FrameworkManager.createDeviceManager((ServerComponent)this);
    }

    public PortType getPortType() {
        return PortType.Tcp;
    }

    @Override
    public synchronized void close() {
        if (this.isStart()) {
            TcpDeviceManager deviceManager = this.getDeviceManager();
            if (deviceManager != null && deviceManager.size() > 0) {
                deviceManager.close().awaitUninterruptibly();
            }
            super.close();
        }
    }
}

