/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.server;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.FrameworkException;
import com.iteaj.iot.IotProtocolFactory;
import com.iteaj.iot.Message;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolTimeoutStorage;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.SocketDeviceManager;
import com.iteaj.iot.SocketProtocolFactory;
import com.iteaj.iot.codec.SocketMessageDecoder;
import com.iteaj.iot.codec.filter.CombinedInterceptor;
import com.iteaj.iot.codec.filter.Interceptor;
import com.iteaj.iot.codec.filter.RegisterParams;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.server.IotSocketServer;
import com.iteaj.iot.server.ServerComponent;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.protocol.ClientInitiativeProtocol;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.util.ReferenceCounted;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketServerComponent<M extends ServerMessage, R extends ReferenceCounted>
extends SocketProtocolFactory<M>
implements ServerComponent,
IotSocketServer,
SocketMessageDecoder<R>,
CombinedInterceptor {
    private boolean start;
    private long startTime;
    private CombinedInterceptor interceptor;
    private Channel channel;
    private boolean override = true;
    private Class<M> messageClass;
    private Constructor<M> constructor;
    private SocketDeviceManager deviceManager;
    private ConnectProperties connectProperties;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SocketServerComponent(ConnectProperties connectProperties) {
        this.connectProperties = connectProperties;
        this.setDelegation(this.protocolTimeoutStorage());
    }

    public SocketServerComponent(ConnectProperties connectProperties, CombinedInterceptor interceptor) {
        this.interceptor = interceptor;
        this.connectProperties = connectProperties;
        this.setDelegation(this.protocolTimeoutStorage());
    }

    protected void doBind(AbstractBootstrap sb) {
        ChannelFuture bind = StrUtil.isNotBlank((CharSequence)this.config().getHost()) ? sb.bind(this.config().getHost(), this.config().getPort().intValue()) : sb.bind(this.config().getPort().intValue());
        this.channel = bind.addListener(future -> {
            String host;
            Integer port = this.config().getPort();
            String string = host = this.config().getHost() == null ? "0.0.0.0" : this.config().getHost();
            if (future.isSuccess()) {
                LOGGER.info("\u76d1\u542c\u7aef\u53e3\u6210\u529f({}) \u4e3b\u673a\uff1a{}:{} - \u7b80\u4ecb\uff1a{}", new Object[]{this.getName(), host, port, this.getDesc()});
            } else {
                LOGGER.error("\u76d1\u542c\u7aef\u53e3\u5931\u8d25({}) \u4e3b\u673a: {}:{} - \u7b80\u4ecb\uff1a{} - \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{this.getName(), host, port, this.getDesc(), future.cause().getMessage(), future.cause()});
            }
        }).syncUninterruptibly().channel();
        this.channel.attr(CoreConst.COMPONENT).set((Object)this);
    }

    protected void doInitChannel(ChannelPipeline p) {
        if (this.config().getSsl() != null) {
            p.addFirst("IOT_SSL", (ChannelHandler)new SslHandler(null));
        }
    }

    public void start(Object config) {
        if (!this.isStart()) {
            this.setStart(true);
            this.startTime = System.currentTimeMillis();
            this.deviceManager = this.createDeviceManager();
            if (config instanceof Interceptor) {
                this.interceptor = (CombinedInterceptor)config;
            }
            if (this.interceptor == null) {
                this.interceptor = CombinedInterceptor.DEFAULT;
            }
            AbstractBootstrap abstractBootstrap = this.initParentChannel();
            this.doBind(abstractBootstrap);
        }
    }

    protected abstract AbstractBootstrap initParentChannel();

    public ConnectProperties config() {
        return this.connectProperties;
    }

    protected abstract ClientInitiativeProtocol<M> doGetProtocol(M var1, ProtocolType var2);

    public Optional<ChannelFuture> writeAndFlush(String equipCode, Object msg, Object ... args) {
        return this.getDeviceManager().writeAndFlush(equipCode, msg, args);
    }

    public Optional<ChannelFuture> writeAndFlush(String equipCode, Protocol protocol) {
        return this.writeAndFlush(equipCode, protocol, null);
    }

    public SocketDeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public IotProtocolFactory protocolFactory() {
        return this;
    }

    protected abstract SocketDeviceManager createDeviceManager();

    public M createMessage(byte[] message) {
        try {
            return (M)((ServerMessage)this.resolveConstructor().newInstance(new Object[]{message}));
        }
        catch (ReflectiveOperationException e) {
            throw new FrameworkException((Throwable)e);
        }
    }

    public boolean isDecoder(Channel channel, ReferenceCounted msg) {
        return this.getInterceptor().isDecoder(channel, msg);
    }

    public Object idle(String deviceSn, IdleState state) {
        return this.getInterceptor().idle(deviceSn, state);
    }

    public boolean isActivation(Channel channel, FrameworkComponent component) {
        return this.getInterceptor().isActivation(channel, component);
    }

    public Message.MessageHead register(Message.MessageHead head, RegisterParams params) {
        return this.getInterceptor().register(head, params);
    }

    public CombinedInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(CombinedInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Class<M> getMessageClass() {
        if (this.messageClass == null) {
            this.messageClass = ClassUtil.getTypeArgument(((Object)((Object)this)).getClass(), (int)0);
            if (this.messageClass == null) {
                throw new IllegalArgumentException("\u672a\u6307\u5b9a\u6cdb\u578b[" + ((Object)((Object)this)).getClass().getSimpleName() + "<M>]");
            }
            this.resolveConstructor();
        }
        return this.messageClass;
    }

    private Constructor<M> resolveConstructor() {
        if (this.constructor == null) {
            try {
                this.constructor = this.getMessageClass().getConstructor(byte[].class);
            }
            catch (NoSuchMethodException e) {
                String simpleName = this.getMessageClass().getSimpleName();
                throw new ProtocolException("\u62a5\u6587\u7c7b\u578b\u7f3a\u5c11\u6784\u9020\u51fd\u6570[" + simpleName + "(byte[])]", (Throwable)e);
            }
        }
        return this.constructor;
    }

    protected final ProtocolTimeoutStorage protocolTimeoutStorage() {
        if (this.getDelegation() != null) {
            return this.getDelegation();
        }
        return this.doCreateProtocolTimeoutStorage();
    }

    protected ProtocolTimeoutStorage doCreateProtocolTimeoutStorage() {
        return new ProtocolTimeoutStorage(this.getName());
    }

    public long startTime() {
        return this.startTime;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    protected Channel getChannel() {
        return this.channel;
    }

    protected void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void close() {
        if (this.getChannel() != null) {
            this.getChannel().close().syncUninterruptibly().addListener(future -> {
                String host;
                this.setStart(false);
                String string = host = this.config().getHost() == null ? "0.0.0.0" : this.config().getHost();
                if (future.isSuccess()) {
                    this.logger.info("\u5173\u95ed\u7ec4\u4ef6\u6210\u529f({}) \u4e3b\u673a: {}:{} - \u7b80\u4ecb: {}", new Object[]{this.getName(), host, this.config().getPort(), this.getDesc()});
                } else {
                    this.logger.error("\u5173\u95ed\u7ec4\u4ef6\u5931\u8d25({}) \u4e3b\u673a: {}:{} - \u7b80\u4ecb: {}", new Object[]{this.getName(), host, this.config().getPort(), this.getDesc(), future.cause()});
                }
            });
        }
    }

    public boolean isStart() {
        return this.start;
    }

    protected void setStart(boolean start) {
        this.start = start;
    }
}

