/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCSSException;
import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmContext;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class IfxCss {
    static final int CSS_NOERROR = 0;
    static final int CSS_MIN_ERROR = -14500;
    static final int CSS_MAX_ERROR = -14699;
    static final int CSS_ERROR = -14500;
    static final int CSS_ENOMEMORY = -14501;
    static final int CSS_ECSM_NOT_FOUND = -14502;
    static final int CSS_ELOAD_LIB = -14503;
    static final int CSS_EBAD_CSM_VERSION = -14504;
    static final int CSS_ECSM = -14505;
    static final int CSS_ECSM_BAD_CODE = -14506;
    static final int CSS_EDISCONNECTED = -14507;
    static final int CSS_ECSM_GET_FLAGS = -14508;
    static final int CSS_ECASCADE = -14509;
    static final int CSS_EOWNER = -14510;
    static final int CSS_EINIT_PROC = -14511;
    static final int CSS_ENO_LIB = -14512;
    static final int CSS_ECSM_NEED_DATA = -14513;
    static final int CSS_ENOT_IMPLEMENTED = -14550;
    static final int CSS_ENOT_IMPLEMENTED_01 = -14551;
    static final int CSS_EIO = -14560;
    static final int CSS_EIO_00 = -14561;
    static final int CSS_EIO_01 = -14562;
    static final int CSS_EIO_02 = -14563;
    static final int CSS_EIO_03 = -14564;
    static final int CSS_EIO_04 = -14565;
    static final int CSS_EIO_05 = -14566;
    static final int CSS_EIO_06 = -14567;
    static final int CSS_EFAILURE = -14570;
    static final int CSS_EFAILURE_01 = -14571;
    static final int CSS_EFAILURE_02 = -14572;
    static final int CSS_EFAILURE_03 = -14573;
    static final int CSS_EFAILURE_04 = -14574;
    static final int CSS_EFAILURE_05 = -14575;
    static final int CSS_EFAILURE_06 = -14576;
    static final int CSS_EFAILURE_07 = -14577;
    static final int CSS_EFAILURE_08 = -14578;
    static final int CSS_EFAILURE_09 = -14579;
    static final int CSS_EFAILURE_10 = -14590;
    static final int CSS_EFAILURE_11 = -14591;
    static final int CSS_EBAD_INPUT = -14580;
    static final int CSS_EBAD_INPUT_01 = -14581;
    static final int CSS_EBAD_INPUT_02 = -14582;
    static final int CSS_EBAD_INPUT_03 = -14583;
    static final int CSS_EBAD_INPUT_04 = -14584;
    static final int CSS_EBAD_INPUT_05 = -14585;
    static final int CSS_EBAD_INPUT_06 = -14586;
    static final int CSS_EBAD_INPUT_07 = -14587;
    static final int CSS_EBAD_INPUT_08 = -14588;
    private static int CSS_DONE = 0;
    private static final int CSS_DONE_MORE_DATA = 1;
    private static final int CSS_CONT = 2;
    private static final int CSS_CLIENT_SIDE = 0;
    private static final int CSS_SERVER_SIDE = 0;
    private String csmInfo;
    private InputStream dataSource;
    private OutputStream dataSink;
    IfxCsm.Credentials creds;
    private int side;
    private int state_in;
    private int state_out;
    private FilterInputStream is;
    private FilterOutputStream os;
    private IfxCsmContext csmCtx;
    String locale;
    int state;
    int err_code;
    int csm_err_code;
    int os_err_code;
    String err_str;

    public IfxCss(Socket soc, String csmInfo, String clientLocale, IfxCsm.Credentials creds) throws IfxCSSException {
        try {
            this.dataSource = soc.getInputStream();
            this.dataSink = soc.getOutputStream();
        }
        catch (IOException ex) {
            throw IfxErrMsg.getLocIfxCSSException(-14572, clientLocale);
        }
        this.csmInfo = csmInfo;
        this.locale = clientLocale;
        this.creds = creds;
        this.createContext();
    }

    public IfxCss(InputStream in, OutputStream out, String csmInfo, String clientLocale, IfxCsm.Credentials creds) throws IfxCSSException {
        this.dataSource = in;
        this.dataSink = out;
        this.csmInfo = csmInfo;
        this.locale = clientLocale;
        this.creds = creds;
        this.createContext();
    }

    public void createContext() throws IfxCSSException {
        this.loadCsm(this.csmInfo);
        if (this.csmCtx == null) {
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.locale);
        }
        this.populateIOStreams();
        this.csmCtx.init();
        this.csmCtx.createContext(this.creds);
    }

    private void loadCsm(String csmInfo) throws IfxCSSException {
        Object csm = null;
        IfxCsmDescriptor desc = null;
        desc = new IfxCsmDescriptor(csmInfo, this.dataSource, this.dataSink, this.locale);
        this.csmCtx = new IfxCsmContext(desc, this.locale);
    }

    public FilterInputStream getIfxCssInputStream() throws IfxCSSException {
        return this.is;
    }

    public FilterOutputStream getIfxCssOutputStream() throws IfxCSSException {
        return this.os;
    }

    private void populateIOStreams() throws IfxCSSException {
        this.is = this.csmCtx.getInputStream();
        this.os = this.csmCtx.getOutputStream();
    }
}

