/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import com.informix.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;

class IfxMACSecretKeys {
    private static final String MAC_KEY = "E8E9E2F5A602620751599970DE3DDDA3CF170FF4CBC279D831A1459BA2C01E9075941B94B2CD91D8B01F82E1BFDA6F423D0B66C91DA87F3F67225B608B842493072372204E951E276A437E89A2FA32F8C9A6DE7D3CABA351896597A52A4F4F15A5043D2EC4D8E6EB05DCB5D75469CD23E9E321670D07E80AF4AB4548139F0E1FE1B515B775A3656008C8440720007FD4AC4345E8F1C6908505F5D666F0DF0CBECD247028676A14B3E4908B8B58EAEF89AB1AF349A98395B2CA23C77DDA371E56145E3E4788EEC651BDA0A6D684CF6B5868B9FA701866D8DB348DF73F824759C9E5A49A0BD64407BAA04D7DC75E07F12865331874EBD58AED4CEE87E66EA5E24D7EBEF6D6164C5FB19B1E55D7D6E7412E831D8344264E95431FA86FB2851DFAE05B12C8316EA14D2EAE8B3415A0D92FFDC55A1101C25428E4AA6F4FCD39131BC907B8EF6E57FF3A84BB3FBEA94D8612D70973CE2B327083E542630B9697524D561448CC5C11ACA63557077DFA93EFBD51F20415C0E90C35C5E6826EAF91DF58D2DE800E8A648A70C8E20C5B7A7CA2C3692D94C14D922A95D7C42110DD243B0A5178B1FEEDEFEACB0DD0D0F103AEE9619E4A372EC0915A808E443DC37EF2F590D1B8D372D1CA5B9A2AE8AD500C5FC39906D7637C91532078F076207F0CC48F614600722BDB";
    private static final byte[] DEFAULT_KEY_NAME = new byte[]{100, 101, 102, 97, 117, 108, 116};
    static final String MAC_ALGORITHM = "HmacSHA1";
    static final int MAC_HASHKEY_SIZE = 36;
    static final int MAC_NAMESZ = 8;
    static final int MAC_KEYSZ = 512;
    static final int MAC_RDBUFFSZ = 2048;
    static final int MAC_LEVELSZ = 4;
    private static final int MACLIST_COUNT_CSIZE = 2;
    static final int MACKEYTIME_TSEC_CSIZE = 4;
    static final int MACKEYTIME_TMSEC_CSIZE = 4;
    static final int MACKEYTIME_SIZE = 8;
    String File;
    long TimeSec;
    long TimeMs;
    byte[] Name;
    byte[] Key;

    long getTimeSec() {
        return this.TimeSec;
    }

    long getTimeMs() {
        return this.TimeMs;
    }

    byte[] getName() {
        return this.Name;
    }

    byte[] getFixLenName() {
        byte[] ret = new byte[8];
        if (this.Name != null) {
            System.arraycopy(this.Name, 0, ret, 0, this.Name.length >= 8 ? 8 : this.Name.length);
        }
        return ret;
    }

    boolean isNewerThan(IfxMACSecretKeys key) {
        return this.TimeSec > key.getTimeSec() || this.TimeSec == key.getTimeSec() && this.TimeMs > key.getTimeMs();
    }

    static IfxMACSecretKeys findMacKey(byte[] name, long timeSec, long timeMsec, Vector<IfxMACSecretKeys> macKeyList) {
        for (int k = 0; k < macKeyList.size(); ++k) {
            IfxMACSecretKeys tmpKey = macKeyList.get(k);
            if (!Arrays.equals(tmpKey.getFixLenName(), name) || tmpKey.getTimeSec() != timeSec || tmpKey.getTimeMs() != timeMsec) continue;
            return tmpKey;
        }
        return null;
    }

    static int registerMAC(IfxCryptoCtx cryptoCtx, String mac) throws IfxCsmException {
        int status;
        block17: {
            IfxMACSecretKeys tmac;
            int k;
            Vector<IfxMACSecretKeys> macVector;
            IfxMACSecretKeys Mac;
            block19: {
                IfxMsgHdr msgHdr;
                ByteArrayInputStream MacStr;
                IfxEncPkt MACEncPkt;
                byte[] macReadBuff;
                FileInputStream MacFile;
                block18: {
                    status = 0;
                    Mac = null;
                    Object TMac = null;
                    MacFile = null;
                    macReadBuff = null;
                    MACEncPkt = null;
                    MacStr = null;
                    msgHdr = new IfxMsgHdr();
                    macVector = cryptoCtx.registeredMAC;
                    if (!mac.equalsIgnoreCase("default") && !mac.equalsIgnoreCase("builtin")) break block18;
                    Mac = cryptoCtx.DefaultMAC;
                    break block19;
                }
                Mac = new IfxMACSecretKeys();
                try {
                    MacFile = new FileInputStream(mac);
                    macReadBuff = MacFile.available() > 2048 ? new byte[2048] : new byte[MacFile.available()];
                    MacFile.read(macReadBuff);
                    MacFile.close();
                }
                catch (FileNotFoundException ex) {
                    status = -28;
                    break block17;
                }
                catch (IOException ex) {
                    status = -28;
                    break block17;
                }
                try {
                    MACEncPkt = new IfxEncPkt(3, cryptoCtx);
                }
                catch (IfxCsmException ex) {
                    throw IfxCryptoSession.getCsmErrException(-18, ex);
                }
                MACEncPkt.Decrypt.In.resetAndwrite(macReadBuff);
                status = cryptoCtx.parentSession.decrypt(MACEncPkt);
                if (status == 0) {
                    MacStr = new ByteArrayInputStream(MACEncPkt.Decrypt.Out.toByteArray());
                    MACEncPkt = null;
                }
                if (status != 0) break block17;
                while (MacStr.available() > 0) {
                    msgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(MacStr, 4));
                    switch (msgHdr.getType()) {
                        case 13: {
                            Mac.TimeSec = IfxCryptoUtils.readUInt4(MacStr, 4);
                            Mac.TimeMs = IfxCryptoUtils.readUInt4(MacStr, 4);
                            break;
                        }
                        case 14: {
                            Mac.Name = IfxCryptoUtils.readByteInputStream(MacStr, msgHdr.getMsgSize());
                            break;
                        }
                        case 15: {
                            Mac.Key = IfxCryptoUtils.readByteInputStream(MacStr, msgHdr.getMsgSize());
                            break;
                        }
                        default: {
                            status = -25;
                        }
                    }
                    if (status == 0) continue;
                }
                Mac.File = mac;
            }
            for (k = macVector.size() - 1; k >= 0 && !Mac.isNewerThan(tmac = macVector.get(k)); --k) {
            }
            macVector.add(k + 1, Mac);
            Mac = null;
        }
        if (status != 0) {
            IfxCryptoCtx.printError(null, "registereMAC", status);
        }
        return status;
    }

    static int cryptoGetMAC(IfxCsmBuffer buff, IfxCryptoCtx cryptoCtx) {
        Vector<IfxMACSecretKeys> MACVector = cryptoCtx.registeredMAC;
        int status = 0;
        boolean MacSize = false;
        if (MACVector == null || MACVector.isEmpty()) {
            status = -26;
        } else {
            buff.reset();
            buff.write(IfxCryptoUtils.JavaToIfxInt(MACVector.size(), 2));
            for (int k = 0; k < MACVector.size(); ++k) {
                IfxMACSecretKeys mac = MACVector.get(k);
                buff.write(IfxCryptoUtils.JavaToIfxLong(mac.getTimeSec(), 4));
                buff.write(IfxCryptoUtils.JavaToIfxLong(mac.getTimeMs(), 4));
                buff.write(mac.getFixLenName());
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(null, "CryptoGetMAC", status);
        }
        return status;
    }

    static int negotiateMac(IfxEncPkt encPkt, byte[] macStringArray, IfxCryptoCtx ctx) {
        ByteArrayInputStream macString = new ByteArrayInputStream(macStringArray);
        int status = 0;
        int count = 0;
        IfxMACSecretKeys negMac = null;
        Vector<IfxMACSecretKeys> macList = ctx.registeredMAC;
        count = IfxCryptoUtils.readInt(macString, 2);
        while (count-- > 0) {
            long timeSec = IfxCryptoUtils.readUInt4(macString, 4);
            long timeMSec = IfxCryptoUtils.readUInt4(macString, 4);
            byte[] keyName = IfxCryptoUtils.readByteInputStream(macString, 8);
            IfxMACSecretKeys tMac = IfxMACSecretKeys.findMacKey(keyName, timeSec, timeMSec, macList);
            if (tMac == null) continue;
            if (negMac == null) {
                negMac = tMac;
                continue;
            }
            if (tMac.getTimeSec() <= negMac.getTimeSec() && (tMac.getTimeSec() != negMac.getTimeSec() || tMac.getTimeMs() <= negMac.getTimeMs())) continue;
            negMac = tMac;
        }
        if (negMac == null) {
            status = -26;
        } else {
            encPkt.NegotiatedMacKey = negMac.Key;
            if ((ctx.DebugFlags & 0x600) > 0) {
                // empty if block
            }
        }
        return status;
    }

    static IfxMACSecretKeys generateDefaultMacKey() {
        IfxMACSecretKeys defKey = new IfxMACSecretKeys();
        BigInteger defMacNum = new BigInteger(MAC_KEY, 16);
        defKey.Key = IfxCryptoUtils.bigIntegerToBinary(defMacNum);
        defKey.Name = DEFAULT_KEY_NAME;
        return defKey;
    }
}

