/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import net.jpountz.util.SafeUtils;
import net.jpountz.util.Utils;
import sun.misc.Unsafe;

public enum UnsafeUtils {

    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private static final int BYTE_ARRAY_SCALE;
    private static final long INT_ARRAY_OFFSET;
    private static final int INT_ARRAY_SCALE;
    private static final long SHORT_ARRAY_OFFSET;
    private static final int SHORT_ARRAY_SCALE;

    public static void checkRange(byte[] byArray, int n2) {
        SafeUtils.checkRange(byArray, n2);
    }

    public static void checkRange(byte[] byArray, int n2, int n3) {
        SafeUtils.checkRange(byArray, n2, n3);
    }

    public static void checkLength(int n2) {
        SafeUtils.checkLength(n2);
    }

    public static byte readByte(byte[] byArray, int n2) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_OFFSET + (long)(BYTE_ARRAY_SCALE * n2));
    }

    public static void writeByte(byte[] byArray, int n2, byte by2) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_OFFSET + (long)(BYTE_ARRAY_SCALE * n2), by2);
    }

    public static void writeByte(byte[] byArray, int n2, int n3) {
        UnsafeUtils.writeByte(byArray, n2, (byte)n3);
    }

    public static long readLong(byte[] byArray, int n2) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_OFFSET + (long)n2);
    }

    public static long readLongLE(byte[] byArray, int n2) {
        long l10 = UnsafeUtils.readLong(byArray, n2);
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            l10 = Long.reverseBytes(l10);
        }
        return l10;
    }

    public static void writeLong(byte[] byArray, int n2, long l10) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_OFFSET + (long)n2, l10);
    }

    public static int readInt(byte[] byArray, int n2) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_OFFSET + (long)n2);
    }

    public static int readIntLE(byte[] byArray, int n2) {
        int n3 = UnsafeUtils.readInt(byArray, n2);
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            n3 = Integer.reverseBytes(n3);
        }
        return n3;
    }

    public static void writeInt(byte[] byArray, int n2, int n3) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_OFFSET + (long)n2, n3);
    }

    public static short readShort(byte[] byArray, int n2) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_OFFSET + (long)n2);
    }

    public static int readShortLE(byte[] byArray, int n2) {
        short s2 = UnsafeUtils.readShort(byArray, n2);
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            s2 = Short.reverseBytes(s2);
        }
        return s2 & 0xFFFF;
    }

    public static void writeShort(byte[] byArray, int n2, short s2) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_OFFSET + (long)n2, s2);
    }

    public static void writeShortLE(byte[] byArray, int n2, int n3) {
        UnsafeUtils.writeByte(byArray, n2, (byte)n3);
        UnsafeUtils.writeByte(byArray, n2 + 1, (byte)(n3 >>> 8));
    }

    public static int readInt(int[] nArray, int n2) {
        return UNSAFE.getInt(nArray, INT_ARRAY_OFFSET + (long)(INT_ARRAY_SCALE * n2));
    }

    public static void writeInt(int[] nArray, int n2, int n3) {
        UNSAFE.putInt(nArray, INT_ARRAY_OFFSET + (long)(INT_ARRAY_SCALE * n2), n3);
    }

    public static int readShort(short[] sArray, int n2) {
        return UNSAFE.getShort(sArray, SHORT_ARRAY_OFFSET + (long)(SHORT_ARRAY_SCALE * n2)) & 0xFFFF;
    }

    public static void writeShort(short[] sArray, int n2, int n3) {
        UNSAFE.putShort(sArray, SHORT_ARRAY_OFFSET + (long)(SHORT_ARRAY_SCALE * n2), (short)n3);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            BYTE_ARRAY_SCALE = UNSAFE.arrayIndexScale(byte[].class);
            INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_SCALE = UNSAFE.arrayIndexScale(int[].class);
            SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            SHORT_ARRAY_SCALE = UNSAFE.arrayIndexScale(short[].class);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
        catch (SecurityException securityException) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
    }
}

