/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import org.beetl.sql.clazz.kit.StringKit;

public class Base16Codec {
    public static final Base16Codec CODEC_LOWER = new Base16Codec(true);
    public static final Base16Codec CODEC_UPPER = new Base16Codec(false);
    private final char[] alphabets;

    public Base16Codec(boolean lowerCase) {
        this.alphabets = (lowerCase ? "0123456789abcdef" : "0123456789ABCDEF").toCharArray();
    }

    public byte[] decode(CharSequence encoded) {
        if (StringKit.isEmpty(encoded)) {
            return null;
        }
        int len = (encoded = StringKit.trim(encoded)).length();
        if ((len & 1) != 0) {
            encoded = "0" + encoded;
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Base16Codec.toDigit(encoded.charAt(j), j) << 4;
            f |= Base16Codec.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + "at index " + index);
        }
        return digit;
    }
}

