/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.vpc.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.vpc.v2.model.ResourceTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BatchCreateSubnetTagsRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tags")
    private List<ResourceTag> tags = null;

    public BatchCreateSubnetTagsRequestBody withAction(ActionEnum action) {
        this.action = action;
        return this;
    }

    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public BatchCreateSubnetTagsRequestBody withTags(List<ResourceTag> tags) {
        this.tags = tags;
        return this;
    }

    public BatchCreateSubnetTagsRequestBody addTagsItem(ResourceTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ResourceTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public BatchCreateSubnetTagsRequestBody withTags(Consumer<List<ResourceTag>> tagsSetter) {
        if (this.tags == null) {
            this.tags = new ArrayList<ResourceTag>();
        }
        tagsSetter.accept(this.tags);
        return this;
    }

    public List<ResourceTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ResourceTag> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchCreateSubnetTagsRequestBody batchCreateSubnetTagsRequestBody = (BatchCreateSubnetTagsRequestBody)o;
        return Objects.equals(this.action, batchCreateSubnetTagsRequestBody.action) && Objects.equals(this.tags, batchCreateSubnetTagsRequestBody.tags);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCreateSubnetTagsRequestBody {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ActionEnum {
        public static final ActionEnum CREATE = new ActionEnum("create");
        private static final Map<String, ActionEnum> STATIC_FIELDS = ActionEnum.createStaticFields();
        private String value;

        private static Map<String, ActionEnum> createStaticFields() {
            HashMap<String, ActionEnum> map = new HashMap<String, ActionEnum>();
            map.put("create", CREATE);
            return Collections.unmodifiableMap(map);
        }

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            ActionEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new ActionEnum(value);
            }
            return result;
        }

        public static ActionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            ActionEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ActionEnum) {
                return this.value.equals(((ActionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

