/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.obs.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.huaweicloud.sdk.obs.v1.model.Grantee;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@JacksonXmlRootElement(localName="Grant")
public class Grant {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Grantee")
    @JacksonXmlProperty(localName="Grantee")
    private Grantee grantee;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Permission")
    @JacksonXmlProperty(localName="Permission")
    private PermissionEnum permission;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Delivered")
    @JacksonXmlProperty(localName="Delivered")
    private Boolean delivered;

    public Grant withGrantee(Grantee grantee) {
        this.grantee = grantee;
        return this;
    }

    public Grant withGrantee(Consumer<Grantee> granteeSetter) {
        if (this.grantee == null) {
            this.grantee = new Grantee();
            granteeSetter.accept(this.grantee);
        }
        return this;
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public void setGrantee(Grantee grantee) {
        this.grantee = grantee;
    }

    public Grant withPermission(PermissionEnum permission) {
        this.permission = permission;
        return this;
    }

    public PermissionEnum getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionEnum permission) {
        this.permission = permission;
    }

    public Grant withDelivered(Boolean delivered) {
        this.delivered = delivered;
        return this;
    }

    public Boolean getDelivered() {
        return this.delivered;
    }

    public void setDelivered(Boolean delivered) {
        this.delivered = delivered;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Grant that = (Grant)obj;
        return Objects.equals(this.grantee, that.grantee) && Objects.equals(this.permission, that.permission) && Objects.equals(this.delivered, that.delivered);
    }

    public int hashCode() {
        return Objects.hash(this.grantee, this.permission, this.delivered);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Grant {\n");
        sb.append("    grantee: ").append(this.toIndentedString(this.grantee)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    delivered: ").append(this.toIndentedString(this.delivered)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class PermissionEnum {
        public static final PermissionEnum READ = new PermissionEnum("READ");
        public static final PermissionEnum WRITE = new PermissionEnum("WRITE");
        public static final PermissionEnum FULL_CONTROL = new PermissionEnum("FULL_CONTROL");
        private static final Map<String, PermissionEnum> STATIC_FIELDS = PermissionEnum.createStaticFields();
        private String value;

        private static Map<String, PermissionEnum> createStaticFields() {
            HashMap<String, PermissionEnum> map = new HashMap<String, PermissionEnum>();
            map.put("READ", READ);
            map.put("WRITE", WRITE);
            map.put("FULL_CONTROL", FULL_CONTROL);
            return Collections.unmodifiableMap(map);
        }

        PermissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new PermissionEnum(value));
        }

        public static PermissionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof PermissionEnum) {
                return this.value.equals(((PermissionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

