/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.obs.v1;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.FormDataPart;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.obs.v1.ObsCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsSigner {
    private static final String SIGN_SEP = "\n";
    private static final String OBS_PREFIX = "x-obs-";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String X_OBS_PREFIX = "x-obs-";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String X_OBS_DATE = "x-obs-date";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String X_OBS_SECURITY_TOKEN = "x-obs-security-token";
    private static final String DATE = "date";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String FILE = "file";
    private static final List<String> SUB_RESOURCES = Collections.unmodifiableList(Arrays.asList("CDNNotifyConfiguration", "acl", "append", "attname", "backtosource", "cors", "customdomain", "delete", "deletebucket", "directcoldaccess", "encryption", "inventory", "length", "lifecycle", "location", "logging", "metadata", "modify", "name", "notification", "orchestration", "partNumber", "policy", "position", "quota", "rename", "replication", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "restore", "storageClass", "storagePolicy", "storageinfo", "tagging", "torrent", "truncate", "uploadId", "uploads", "versionId", "versioning", "versions", "website", "x-image-process", "x-image-save-bucket", "x-image-save-object", "x-obs-security-token"));
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final MessageDigest MESSAGE_DIGEST;
    private final ObsCredentials credentials;
    private String contentMd5 = "";
    private String contentType = "";
    private String date = "";
    private static final Logger logger;

    public ObsSigner(ObsCredentials credentials) {
        this.credentials = credentials;
    }

    public HttpRequest sign(HttpRequest httpRequest) {
        Map formData;
        String securityToken;
        HttpRequest.HttpRequestBuilder builder = httpRequest.builder();
        URL url = httpRequest.getUrl();
        String bucketName = url.getHost().split("\\.")[0];
        bucketName = "obs".equals(bucketName) ? "" : bucketName;
        String objectName = url.getPath();
        objectName = "/".equals(objectName) ? "" : objectName.substring(1);
        try {
            String encodedObjName = this.urlEncode(objectName);
            builder.withPath("/" + encodedObjName);
            logger.info("urlEncode objectName is " + encodedObjName);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("urlEncode objectName failed!");
            logger.error(e.toString());
        }
        Map<String, List<String>> headers = httpRequest.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("x-obs-") || ((String)entry.getKey()).equalsIgnoreCase(CONTENT_TYPE) || ((String)entry.getKey()).equalsIgnoreCase(CONTENT_MD5)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!httpRequest.haveHeader(X_OBS_DATE).booleanValue() && !httpRequest.haveHeader(DATE).booleanValue()) {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String formatDate = format.format(new Date());
            headers.put(DATE, Collections.singletonList(formatDate));
            builder.addHeader(DATE, formatDate);
        }
        if (httpRequest.getBodyAsString() != null && !httpRequest.haveHeader(CONTENT_MD5).booleanValue()) {
            byte[] md5 = MESSAGE_DIGEST.digest(httpRequest.getBodyAsString().getBytes(StandardCharsets.UTF_8));
            String encode = BASE64_ENCODER.encodeToString(md5);
            headers.put(CONTENT_MD5, Collections.singletonList(encode));
            builder.addHeader(CONTENT_MD5, encode);
        }
        if ((securityToken = this.credentials.getSecurityToken()) != null) {
            builder.addHeader(X_OBS_SECURITY_TOKEN, securityToken);
            headers.put(X_OBS_SECURITY_TOKEN, Collections.singletonList(securityToken));
        }
        if ((formData = httpRequest.getFormData()) != null && formData.containsKey(FILE)) {
            FormDataPart file = (FormDataPart)formData.remove(FILE);
            formData.put(FILE, file);
        } else {
            String signature;
            try {
                signature = this.headerSignature(httpRequest.getMethod().toString(), headers, httpRequest.getQueryParams(), bucketName, objectName);
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw new SdkException("Failed to sign request", (Throwable)e);
            }
            builder.addHeader("Authorization", signature);
        }
        return builder.build();
    }

    public String urlEncode(String input) throws UnsupportedEncodingException {
        return URLEncoder.encode(input, DEFAULT_ENCODING).replaceAll("%7E", "~").replaceAll("%2F", "/").replaceAll("%20", "+");
    }

    private String join(List<?> items, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i).toString();
            sb.append(item);
            if (i >= items.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private boolean isValid(String input) {
        return input != null && !input.equals("");
    }

    private String hmacSha1(String input) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(this.credentials.getSk().getBytes(StandardCharsets.UTF_8), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        return BASE64_ENCODER.encodeToString(mac.doFinal(input.getBytes(StandardCharsets.UTF_8)));
    }

    private String stringToSign(String httpMethod, Map<String, List<String>> headers, Map<String, List<String>> queries, String bucketName, String objectName) throws UnsupportedEncodingException {
        TreeMap<String, String> canonicalizedHeaders = new TreeMap<String, String>();
        ArrayList<String> temp = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String string = entry.getKey();
            if (string == null || entry.getValue() == null || entry.getValue().size() == 0) continue;
            String string2 = string.trim().toLowerCase(Locale.ENGLISH);
            if (string2.equals("content-md5")) {
                this.contentMd5 = entry.getValue().get(0);
                continue;
            }
            if (string2.equals("content-type")) {
                this.contentType = entry.getValue().get(0);
                continue;
            }
            if (string2.equals(DATE)) {
                this.date = (String)((List)entry.getValue()).get(0);
                continue;
            }
            if (!string2.startsWith("x-obs-")) continue;
            for (String value : (List)entry.getValue()) {
                if (value == null) continue;
                temp.add(value.trim());
            }
            canonicalizedHeaders.put(string2, this.join(temp, ","));
            temp.clear();
        }
        if (canonicalizedHeaders.containsKey(X_OBS_DATE)) {
            this.date = "";
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(httpMethod).append(SIGN_SEP).append(this.contentMd5).append(SIGN_SEP).append(this.contentType).append(SIGN_SEP).append(this.date).append(SIGN_SEP);
        for (Map.Entry entry : canonicalizedHeaders.entrySet()) {
            stringToSign.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(SIGN_SEP);
        }
        stringToSign.append("/");
        if (this.isValid(bucketName)) {
            stringToSign.append(bucketName).append("/");
            if (this.isValid(objectName)) {
                stringToSign.append(this.urlEncode(objectName));
            }
        }
        TreeMap<String, String> canonicalizedResource = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry : queries.entrySet()) {
            String key = entry.getKey();
            if (key == null || !SUB_RESOURCES.contains(key)) continue;
            canonicalizedResource.put(key, entry.getValue().get(0));
        }
        if (canonicalizedResource.size() > 0) {
            String string = this.canonicalizeResource(canonicalizedResource);
            stringToSign.append(string);
        }
        return stringToSign.toString();
    }

    private String canonicalizeResource(Map<String, String> canonicalizedResource) {
        StringBuilder resource = new StringBuilder();
        resource.append("?");
        for (Map.Entry<String, String> entry : canonicalizedResource.entrySet()) {
            resource.append(entry.getKey());
            if (this.isValid(entry.getValue())) {
                resource.append("=").append(entry.getValue());
            }
            resource.append("&");
        }
        resource.deleteCharAt(resource.length() - 1);
        return resource.toString();
    }

    private String headerSignature(String httpMethod, Map<String, List<String>> headers, Map<String, List<String>> queries, String bucketName, String objectName) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = this.stringToSign(httpMethod, headers, queries, bucketName, objectName);
        logger.info("stringToSign:" + stringToSign);
        return String.format("OBS %s:%s", this.credentials.getAk(), this.hmacSha1(stringToSign));
    }

    static {
        try {
            MESSAGE_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SdkException("Failed to sign request", (Throwable)e);
        }
        logger = LoggerFactory.getLogger(ObsSigner.class);
    }
}

